#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int cassar(pSurfMesh sm) {
  pHashtable    pht;
  pTriangle     pt;
  int           i,k,i1,i2,ii,iret,npp,kk,nbs,inp[3],vtx[3];

  E_put("cassar");
  npp   = 0;

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    nbs = 0;
    /* analyze edges */
    for (i=0; i<3; i++) {
      vtx[i] = inp[i] = 0;
      if ( pt->tag[i] & M_REQUIRED )  continue;
      i1 = idir[i+1];
      i2 = idir[i+2];
      pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
      if ( !pht )  continue;
      vtx[i] = pht->ind;
      inp[i] = pht->elt;
      if ( vtx[i] ) nbs++;
    }
    if ( !nbs )  continue;
    npp++;
    iret = 1;
    switch(nbs) {
    case 1:
      if ( vtx[0] )
	      iret = split1(sm,k,0,vtx,inp);
      else if ( vtx[1] )
	      iret = split1(sm,k,1,vtx,inp);
      else
	      iret = split1(sm,k,2,vtx,inp);
      break;
    case 2:
      if ( !vtx[0] )
	      iret = split2(sm,k,0,vtx,inp);
      else if ( !vtx[1] )
	      iret = split2(sm,k,1,vtx,inp);
      else
	      iret = split2(sm,k,2,vtx,inp);
      break;
    case 3:
      iret = split3(sm,k,vtx,inp);
      break;
    }

    if ( !iret )  return(0);
    else if ( sm->ne > sm->nemax-4 ) {
      yerr.inderr[0] = sm->ne;
      yerr.inderr[1] = sm->nemax;
      prierr(WAR,4001);
      E_pop();
      return(0);
    }
  }
  if ( npp && !updtop(sm) )  return(0);

  E_pop();
  return(1);
}
