/* 
 *  compute parabola coefficients
 *  y = a*x*x + b*x
 *  passing through p0,p1,p2
 *
 *  return 0: unable to define quadric
 *         1: quadric ok
 *         2: straight line
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved.
*/

#ifdef __cplusplus
extern "C" {
#endif


#include "yams.h"
#include "extern.h"
#include "sproto.h"

#define  EPSARC   1.e-12


int calpar(pPoint p0,pPoint p1,pPoint p2,double *u,double *v,double *par) {
  double    ux,uy,uz,vx,vy,vz;
  double    dd,w[3],xx1,xx2,yy1,yy2;

  /* default */
  par[0] = par[1] = 0.0f;

  ux = p1->c[0] - p0->c[0];
  uy = p1->c[1] - p0->c[1];
  uz = p1->c[2] - p0->c[2];

  vx = p2->c[0] - p0->c[0];
  vy = p2->c[1] - p0->c[1];
  vz = p2->c[2] - p0->c[2]; 

  /* find vector v-u */
  u[0] = vx - ux;
  u[1] = vy - uy;
  u[2] = vz - uz;
  dd = u[0]*u[0] + u[1]*u[1] + u[2]*u[2];
  if ( dd == 0.0f )  return(0);
  dd = 1.0 / sqrt(dd);
  u[0] *= dd;  u[1] *= dd;  u[2] *= dd;

  /* cross product u v */
  w[0] = uy*vz - uz*vy;
  w[1] = uz*vx - ux*vz;
  w[2] = ux*vy - uy*vx;
  dd = w[0]*w[0] + w[1]*w[1] + w[2]*w[2];
  /* on straight edge */
  if ( dd == 0.0f )  return(2);

  dd = 1.0 / sqrt(dd);
  w[0] *= dd;  w[1] *= dd;  w[2] *= dd;

  /* cross product w u */
  v[0] = w[1]*u[2] - w[2]*u[1];
  v[1] = w[2]*u[0] - w[0]*u[2];
  v[2] = w[0]*u[1] - w[1]*u[0];

  /* get u1 in local frame */
  xx1 = ux*u[0] + uy*u[1] + uz*u[2];
  yy1 = ux*v[0] + uy*v[1] + uz*v[2];
  xx2 = vx*u[0] + vy*u[1] + vz*u[2];
  yy2 = vx*v[0] + vy*v[1] + vz*v[2];
  if ( fabs(xx1*xx2*(xx1-xx2)) < EPSARC )  return(2);

  /* in local frame: y = a*x*x + b*x  (parabola) */
  par[0] = (yy1*xx2 - yy2*xx1) / (xx1*xx2*(xx1-xx2));
  par[1] = (yy1*xx2*xx2 - yy2*xx1*xx1) / (xx1*xx2*(xx2-xx1));

  return(1);
}


#ifdef __cplusplus
}
#endif
