/*
 *  search all triangles having p as vertex
 *  in  : P the vertex
 *        depart a triangle having P
 *  out : list  of desired triangles
 *        nump  position of P in list[i]
 *        ilist number of triangles found (-1/overflow)
 *        closed TRUE if closed ball
 *
 *  Written by, Pascal J. Frey
 *  Copyright (c) Inria, 1998, 2000.  All rights reserved.
*/
#include "yams.h"
#include "defines.h"
#include "extern.h"
#include "sproto.h"

#define LONMAX1    LONMAX-1


int boulep(pSurfMesh sm,int depart,int i,Ball *b) {
  pTriangle  pt;
  int        adj;
  ubyte      voy;

  /* default */
  b->closed = FALSE;
  b->ilist  = 1;
  b->list[b->ilist] = depart;
  b->nump[b->ilist] = i;

  /* start from initial face */
  pt  = &sm->tria[depart] ;
  voy = idir[i+1];
  adj = pt->adj[voy];

  /* search triangles in ball */
  while ( (adj != depart) && !(pt->tag[voy] & M_RIDGE_GEO) ) {
    if ( b->ilist >= LONMAX )   return(-1);

    b->list[++b->ilist] = adj;
    voy = pt->voy[voy];
    b->nump[b->ilist] = idir[voy+1];
    voy = idir[voy+2];
    pt  = &sm->tria[adj];
    adj = pt->adj[voy];
  }

  /* check open ball */
  if ( adj == depart && !(pt->tag[voy] & M_RIDGE_GEO) ) {
    b->closed = TRUE;
    return(b->ilist);
  }

  /* re-start from initial face */
  pt  = &sm->tria[depart];
  voy = idir[i+2];
  adj = pt->adj[voy];

  while ( (adj != depart) && !(pt->tag[voy] & M_RIDGE_GEO) ) {
    if ( b->ilist >= LONMAX )  return(-1);

    b->list[++b->ilist] = adj;
    voy = pt->voy[voy];
    b->nump[b->ilist] = idir[voy+2];
    voy = idir[voy+1];
    pt  = &sm->tria[adj];
    adj = pt->adj[voy];
  }
  if ( adj == depart && !(pt->tag[voy] & M_RIDGE_GEO) )
    b->closed = TRUE;

  return(b->ilist);
}


int boulep2(pSurfMesh sm,int depart,int i,Ball *b) {
  pTriangle  pt;
  int        adj;
  ubyte      voy;

  /* default */
  b->closed = FALSE;
  b->ilist  = 1;
  b->list[b->ilist] = depart;
  b->nump[b->ilist] = i;

  /* start from initial face */
  pt  = &sm->tria[depart] ;
  voy = idir[i+1];
  adj = pt->adj[voy];

  /* search triangles in ball */
  while ( (adj != depart) && (pt->tag[voy] == M_NOTAG) ) {
    if ( b->ilist >= LONMAX )   return(-1);

    b->list[++b->ilist] = adj;
    voy = pt->voy[voy];
    b->nump[b->ilist] = idir[voy+1];
    voy = idir[voy+2];
    pt  = &sm->tria[adj];
    adj = pt->adj[voy];
  }

  /* check open ball */
  if ( adj == depart && (pt->tag[voy] == M_NOTAG) ) {
    b->closed = TRUE;
    return(b->ilist);
  }

  /* re-start from initial face */
  pt  = &sm->tria[depart];
  voy = idir[i+2];
  adj = pt->adj[voy];

  while ( (adj != depart) && (pt->tag[voy] == M_NOTAG) ) {
    if ( b->ilist >= LONMAX )  return(-1);

    b->list[++b->ilist] = adj;
    voy = pt->voy[voy];
    b->nump[b->ilist] = idir[voy+2];
    voy = idir[voy+1];
    pt  = &sm->tria[adj];
    adj = pt->adj[voy];
  }
  if ( adj == depart && (pt->tag[voy] == M_NOTAG) )
    b->closed = TRUE;

  return(b->ilist);
}
