#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int bilan(pSurfMesh sm) {
  pTriangle pt;
  pPoint    ppt;
  int       i,k,adj;

  /* analyze triangles */
  E_put("bilan");
  sm->mark++;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[ k ];
    if ( pt->v[0] > 0 ) {

      /* analyze face edges */
      for (i=0; i<3; i++) {
	ppt = &sm->point[ pt->v[i] ];

	if ( ppt->color != sm->mark ) {
	  ppt->color = sm->mark;
	  if ( ppt->tag & M_REQUIRED )
	    info.nvrequis++;
	  if ( ppt->tag & M_CORNER )
	    info.ncoi++;
	}

	/* check singularities */
	adj = pt->adj[ i ];
	if ( !adj || adj > k ) {
	  ++info.nedg;
	  if ( pt->tag[i] & M_REQUIRED )
	    info.nreq++; 
	  if ( pt->tag[i] & M_RIDGE_GEO || pt->tag[i] & M_RIDGE_REF )
	    info.nrid++;
	}
      }
    }
  }

  fprintf(stdout,"\n  -- SURFACE MESH INFORMATION\n");
  fprintf(stdout,"  ** GEOMETRY\n");
  fprintf(stdout,"     EXTREMA COORDINATES   : %12.4f %12.4f %12.4f\n",
	  info.xmin,info.ymin,info.zmin);
  fprintf(stdout,"                             %12.4f %12.4f %12.4f\n",
	  info.xmax,info.ymax,info.zmax);
  fprintf(stdout,"     EDGE LENGTHS RANGE    : %12.4f %12.4f\n",info.dmin,info.dmax);
/*
  fprintf(stdout,"     CURVATURES MIN,MAX    : %12.4f %12.4f\n",opts.kmin,opts.kmax);
  fprintf(stdout,"     SIZES @ VERTEX MIN,MAX: %12.4f  %.4f\n",opts.hmin,opts.hmax);
*/
  fprintf(stdout,"     NORMALS @ FACES,VERT. : %12d %12d (%d NULL)\n",
	  sm->ne,sm->nv,info.nuln);
  if ( sm->nt )
    fprintf(stdout,"     TANGENTS @ VERTICES   : %12d\n",sm->nt);

  fprintf(stdout,"  ** TOPOLOGY : %d CONNECTED COMPONENT(S)  (GENUS = %d)\n",
          info.cc,(2-sm->np+info.nedg-sm->ne)/2);
  if ( info.manifold == FALSE )
    fprintf(stdout,"     [ NON-MANIFOLD MODEL ]\n");
  fprintf(stdout,"     TRIANGLES: %8d   FLIP   : %8d   FLAT      : %8d\n",
          sm->ne,info.flip,info.nulf);
  fprintf(stdout,"     EDGES    : %8d   RIDGES : %8d   REQ./DANG.: %8d / %d\n",
          info.nedg,info.nrid,info.nreq,info.ndang);
  fprintf(stdout,"     VERTICES : %8d   CORNERS: %8d   REQ./UNUS.:.%8d / %d\n",
          sm->np,info.ncoi,info.nvrequis,info.nulp);

  E_pop();
  return(1);
}


#ifdef __cplusplus 
}
#endif
