#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int analfa(pSurfMesh sm,double cgap,int *alert) {
  pHashtable  pht,phtab[3];
  pTriangle   pt;
  pPoint      p0,p1;
  double      dd,ux,uy,uz,hmax2,hmin2,gap;
  float      *n;
  int         i,i1,i2,k,kk,ii,ij,na,s,vtx[3],inp[3];
  int         ok,ncor;

  /* default */
  E_put("analfa");
  hmax2 = 1.0e30;
  hmin2 = 0.0;
  if ( opts.hmax > 0.0 )  hmax2 = opts.hmax*opts.hmax;
  if ( opts.hmin > 0.0 )  hmin2 = 0.25*opts.hmin*opts.hmin;

  /* reset hash table */
  for (k=1; k<nhmax; k++)
    hash[k].ind = 0;

  /* analyze edges */
  *alert = 0;
  na = 0;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    pt->flag1 = sm->mark+1;
    pt->flag2 = 0;

    /* check edge lengths */
    ok = 1;
    if ( opts.hmax > 0.0 ) {
      for (i=0; i<3; i++) {
        i1 = idir[i+1];
        i2 = idir[i+2];
        if ( pt->tag[i] & M_REQUIRED )  continue;
        p0 = &sm->point[pt->v[i1]];
        p1 = &sm->point[pt->v[i2]];
        ux = p1->c[0] - p0->c[0];
        uy = p1->c[1] - p0->c[1];
        uz = p1->c[2] - p0->c[2];
        dd = ux*ux + uy*uy + uz*uz;
        if ( dd > hmax2 )  break;
      }
      if ( i < 3 )  ok = 0;
    }

    /* local deformation */
    if ( ok && sm->type & M_QUERY ) {
      gap = 1.0;
      for (i=0; i<3; i++) {
        if ( sm->point[pt->v[i]].tag & M_CORNER )  continue;
        if ( !pt->vn[i] ) {
          sm->point[pt->v[i]].tag |= M_CORNER;
          continue;
        }
        n  = sm->geom[pt->vn[i]].vn;
        dd = pt->n[0]*n[0] + pt->n[1]*n[1] + pt->n[2]*n[2];
        if ( dd < gap )  gap = dd;
      }
      if ( gap >= cgap )  continue;
    }
    else if ( ok )  continue;

    /* split triangle */
    pt->flag2 = 0;
    for (i=0; i<3; i++) {
      i1  = idir[i+1];
      i2  = idir[i+2];
      if ( pt->tag[i] & M_REQUIRED )  continue;

      p0 = &sm->point[pt->v[i1]];
      p1 = &sm->point[pt->v[i2]];
      ux = p1->c[0] - p0->c[0];
      uy = p1->c[1] - p0->c[1];
      uz = p1->c[2] - p0->c[2];
      dd = ux*ux + uy*uy + uz*uz;
      if ( dd < hmin2 )  continue;

      pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
      if ( !pht ) {
        yerr.inderr[0] = pt->v[i1];
        yerr.inderr[1] = pt->v[i2];
        prierr(ERR,1015);
        exit(1);
      }
      else if ( pht->ind ) continue;

      if ( !addver(sm,k,i,pht,0.5) ) {
        *alert = 1;
        return(na);
      }
      na++;
      pt->flag2++;
    }
  }
  if ( !na ) {
    E_pop();
    return(0);
  }

  /* balancing */
  do {
    ncor = 0;
    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;
      else if ( pt->flag2 == 3 )  continue;
      s  = 0;
      ij = -1;
      for (i=0; i<3; i++) {
        i1 = idir[i+1];
        i2 = idir[i+2];
        vtx[i]   = 0;
        phtab[i] = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
        if ( !phtab[i] )  continue;
        else if ( phtab[i]->ind ) {
          vtx[i] = phtab[i]->ind;
          s++;
        }
        else  ij = i;
      }
      if ( s == 2 && (pt->tag[ij] & M_REQUIRED) ) {
        if ( !addver(sm,k,ij,phtab[ij],0.5) ) {
          *alert = 1;
          return(na);
        }
        pt->flag2 = 3;
        ncor++;
        na++;
      }
      else pt->flag2 = s;
    }
  }
  while ( ncor > 1 & !*alert );

  /* checking validity */
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    pt->flag2 = 0;
  }
  do {
    ncor = 0;
    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;
      /* analyze edges */
      s = 0;
      for (i=0; i<3; i++) {
        vtx[i] = inp[i] = 0;
        if ( pt->tag[i] & M_REQUIRED )  continue;
        i1 = idir[i+1];
        i2 = idir[i+2];
        pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);

        if ( !pht )  continue;
        vtx[i] = pht->ind;
        inp[i] = pht->elt;
        if ( vtx[i] ) s++;
      }
      if ( pt->flag2 == s )  continue;
      pt->flag2 = s;
      if ( !pt->flag2 )  continue;

      switch (s) {
      case 1:
        for (i=0; i<3; i++) {
          if ( !vtx[i] )  continue;
          if ( !chkspl1(sm,k,i,vtx,inp,cgap) ) {
            /*
            sm->point[-vtx[i]].tmp = sm->point[0].tmp;
            sm->point[0].tmp       = -vtx[i]; */
            na--;
            ncor++;
          }
          break;
        }
        break;
      
      case 2:
        for (i=0; i<3; i++) {
          if ( vtx[i] ) continue;
          if ( !chkspl2(sm,k,i,vtx,inp,cgap) ) {
            if ( vtx[idir[i+1]] < 0 )  na--;
            if ( vtx[idir[i+2]] < 0 )  na--;
            ncor++;
            /*
            iv = vtx[idir[i+1]];
            if ( iv < 0 ) {
              sm->point[-iv].tmp = sm->point[0].tmp;
              sm->point[0].tmp   = -iv;
              na--;
              ncor++;
            }
            iv = vtx[idir[i+2]];
            if ( iv < 0 ) {
              sm->point[-iv].tmp = sm->point[0].tmp;
              sm->point[0].tmp   = -iv;
              na--;
              ncor++;
            }
            */
          }
          break;
        }
        break;

      case 3:
        if ( !chkspl3(sm,k,vtx,inp,cgap) ) {
          for (i=0; i<3; i++)
            if ( vtx[i] < 0 )  na--;
              /*
              sm->point[-vtx[i]].tmp = sm->point[0].tmp;
              sm->point[0].tmp       = -vtx[i]; */
          ncor++;
        }
        break;
      }
    }
  }
  while ( ncor > 1 && na > 0 );

  if ( imprim < -5 ) {
    yerr.inderr[0] = na;
    primsg(2007);
  }

  E_pop();
  return(na);
}
