#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

int *ntab;

int analar_q(pSurfMesh sm,int *alert) {
  pHashtable  pht;
  pTriangle   pt;
  pPoint      ppt;
  pGeomSupp   go;
  double      dd;
  float       c[3],n[3],nn[3],x[3];
  int         k,kk,ii,na,nt,nq,ret;
  ubyte       i,i1,i2;

  /* default */
  E_put("analar_q");
  nt = nq = na = 0;
  *alert  = 0;

  /* reset hash table */
  for (k=1; k<nhmax; k++)
    hash[k].ind = hash[k].elt = 0;

  ntab = (int*)M_malloc((sm->nvmax+1)*sizeof(int),"analar_q");
  assert(ntab);

  /* step 1: create vertices */
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    for (i=0; i<3; i++) {
      if ( abs(pt->adj[i]) > k )  continue;
      i1  = idir[i+1];
      i2  = idir[i+2];

      pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
      if ( !pht ) {
        yerr.inderr[0] = pt->v[i1];
        yerr.inderr[1] = pt->v[i2];
        prierr(ERR,1015);
        exit(1);
      }
      
      if ( !addver(sm,k,i,pht,0.5) ) {
        *alert = 1;
        return(na);
      }
      na++;
    }
    if ( pt->flag2 < 10 ) {
      nq++;
      continue;
    }

    /* add barycenter */
    nt++;
    pt->nxt = ++sm->np;
    c[0] = c[1] = c[2] = 0.0;
    n[0] = n[1] = n[2] = 0.0;

    if ( sm->type & M_QUERY )
      for (i=0; i<3; i++) {
        ret = coorpo(sm,k,i,x,0.5,nn);
        c[0] += x[0];
        c[1] += x[1];
        c[2] += x[2];
        if ( pt->tag[i] & M_NOTAG ) {
          n[0] += nn[0];
          n[1] += nn[1];
          n[2] += nn[2];
        }
        else {
          n[0] += pt->n[0];
          n[1] += pt->n[1];
          n[2] += pt->n[2];
        }
      }
    else {
      for (i=0; i<3; i++) {
        ppt = &sm->point[pt->v[i]];
        c[0] += ppt->c[0];
        c[1] += ppt->c[1];
        c[2] += ppt->c[2];
        
	    go = &sm->geom[pt->vn[i]];
        n[0] += go->vn[0];
        n[1] += go->vn[1];
        n[2] += go->vn[2];
      }
    }

    ppt = &sm->point[sm->np];
    dd  = 1.0 / 3.0;
    ppt->c[0] = dd * c[0];
    ppt->c[1] = dd * c[1];
    ppt->c[2] = dd * c[2];
    ppt->ref  = 0;

    dd = 1.0 / sqrt(n[0]*n[0] + n[1]*n[1] + n[2]*n[2]);
    go = &sm->geom[++sm->nv];
    go-> gap = 1.0f;
    go->vn[0] = n[0] * dd;
    go->vn[1] = n[1] * dd;
    go->vn[2] = n[2] * dd;
    ntab[pt->nxt] = sm->nv;
  }
  sm->nq = 3 * nt + 4 * nq;
  if ( !na )  M_free(ntab);

  E_pop();
  return(na);
}

