#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define LADMI    1.4143


float dicoar(float *p0,float *p1,pMetric ma,pMetric mb,double t,double s) {
  Metric    mm;
  double    dd1,dd2,ux,uy,uz;
  static double tail1,tail2;

  if ( s < 0.001 )  return(t);
  if ( !intme2_a(ma,mb,&mm,t) )  return(t);

  /* edge length */
  ux = t*(p1[0] - p0[0]);
  uy = t*(p1[1] - p0[1]);
  uz = t*(p1[2] - p0[2]);

  dd1 =      ma->m[0]*ux*ux + ma->m[3]*uy*uy + ma->m[5]*uz*uz \
      + 2.0*(ma->m[1]*ux*uy + ma->m[2]*ux*uz + ma->m[4]*uy*uz);
  if ( dd1 <= 0.0 )  dd1 = 0.0;

  dd2 =      mm.m[0]*ux*ux + mm.m[3]*uy*uy + mm.m[5]*uz*uz \
      + 2.0*(mm.m[1]*ux*uy + mm.m[2]*ux*uz + mm.m[4]*uy*uz);
  if ( dd2 <= 0.0 )  dd2 = 0.0;
  tail1 = (sqrt(dd1)+sqrt(dd2) + 4.0*sqrt(0.5*(dd1+dd2))) / 6.0;

  ux = (1.0-t)*(p1[0] - p0[0]);
  uy = (1.0-t)*(p1[1] - p0[1]);
  uz = (1.0-t)*(p1[2] - p0[2]);

  dd1 =      mb->m[0]*ux*ux + mb->m[3]*uy*uy + mb->m[5]*uz*uz \
      + 2.0*(mb->m[1]*ux*uy + mb->m[2]*ux*uz + mb->m[4]*uy*uz);
  if ( dd1 <= 0.0 )  dd1 = 0.0;

  dd2 =      mm.m[0]*ux*ux + mm.m[3]*uy*uy + mm.m[5]*uz*uz \
      + 2.0*(mm.m[1]*ux*uy + mm.m[2]*ux*uz + mm.m[4]*uy*uz);
  if ( dd2 <= 0.0 )  dd2 = 0.0;
  tail2 = (sqrt(dd1)+sqrt(dd2) + 4.0*sqrt(0.5*(dd1+dd2))) / 6.0;

  s = 0.5 * s;
  if ( tail1/tail2 > 1.1 )
    return(dicoar(p0,p1,ma,mb,t-s,s));
  else if ( tail2/tail1 > 1.1 )
    return(dicoar(p0,p1,ma,mb,t+s,s));

  return(t);
}


/* analyze edge lengths (anisotropic) */
int analar_a(pSurfMesh sm,double angdev,int *alert) {
  pHashtable  pht;
  pTriangle   pt;
  pPoint      p0,p1;
  pMetric     ma,mb;
  double      dd,dd1,dd2,hmin2,tail,ux,uy,uz;
  int         i,i1,i2,k,kk,ii,na,nb,s,ncor,vtx[3],inp[3];

  /* default */
  E_put("analar_a");
  na    = sm->np;
  hmin2 = 0.0;
  if ( opts.hmin > 0.0 )  hmin2 = 0.25*opts.hmin*opts.hmin;

  /* reset hash table */
  for (k=1; k<nhmax; k++)
    hash[k].ind = hash[k].elt = 0;

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    pt->flag2 = 0;
  }

  /* analyze edge length */
  *alert = 0;
  na = 0;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    pt->flag1 = sm->mark+1;

    for (i=0; i<3; i++) {
      i1 = idir[i+1];
      i2 = idir[i+2];
      if ( pt->tag[i] & M_REQUIRED )  continue;
      /*else if ( pt->adj[i] > k )  continue;*/

      p0 = &sm->point[pt->v[i1]];
      p1 = &sm->point[pt->v[i2]];

      ux = p1->c[0] - p0->c[0];
      uy = p1->c[1] - p0->c[1];
      uz = p1->c[2] - p0->c[2];
      dd = ux*ux + uy*uy + uz*uz;
      if ( dd < hmin2 )  continue;

      ma = &sm->metric[pt->v[i1]];
      mb = &sm->metric[pt->v[i2]];

      /* compute length */
      dd1 =      ma->m[0]*ux*ux + ma->m[3]*uy*uy + ma->m[5]*uz*uz \
          + 2.0*(ma->m[1]*ux*uy + ma->m[2]*ux*uz + ma->m[4]*uy*uz);
      if ( dd1 <= 0.0 )  dd1 = 0.0;
      dd2 =      mb->m[0]*ux*ux + mb->m[3]*uy*uy + mb->m[5]*uz*uz \
          + 2.0*(mb->m[1]*ux*uy + mb->m[2]*ux*uz + mb->m[4]*uy*uz);
      if ( dd2 <= 0.0 )  dd2 = 0.0;
      tail = (sqrt(dd1)+sqrt(dd2) + 4.0*sqrt(0.5*(dd1+dd2))) / 6.0;
      if ( tail < LADMI )  continue;

      nb = (int)(tail+0.5);
      if ( nb*(nb+1) < 0.99*tail*tail )  nb++;
      if ( nb < 1 )  continue;

      /* split edge */
      pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
      if ( !pht ) {
        yerr.inderr[0] = pt->v[i1];
        yerr.inderr[1] = pt->v[i2];
        prierr(ERR,1015);
        exit(1);
      }
      else if ( pht->ind ) continue;

      if ( !addver(sm,k,i,pht,0.5) ) {
        *alert = 1;
        return(na);
      }
      na++;
    }
  }

  /* checking validity */
  do {
    ncor  = 0;
    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;

      /* analyze edges */
      s = 0;
      for (i=0; i<3; i++) {
        vtx[i] = inp[i] = 0;
        if ( pt->tag[i] & M_REQUIRED )  continue;
        i1 = idir[i+1];
        i2 = idir[i+2];
        pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);

        if ( !pht )  continue;
        vtx[i] = pht->ind;
        inp[i] = pht->elt;
        if ( vtx[i] ) s++;
      }
      if ( pt->flag2 == s )  continue;
      pt->flag2 = s;
      if ( !pt->flag2 )  continue;
      
      switch (s) {
      case 1:
        for (i=0; i<3; i++) {
          if ( !vtx[i] )  continue;
          if ( !chkspl1_a(sm,k,i,vtx,inp,angdev) ) {
            na--;
            ncor++;
          }
          break;
        }
        break;

      case 2:
        for (i=0; i<3; i++) {
          if ( vtx[i] ) continue;
          if ( !chkspl2_a(sm,k,i,vtx,inp,angdev) ) {
            if ( vtx[idir[i+1]] < 0 )  na--;
            if ( vtx[idir[i+2]] < 0 )  na--;
            ncor++;
          }
          break;
        }
        break;

      case 3:
        if ( !chkspl3_a(sm,k,vtx,inp,angdev) ) {
          for (i=0; i<3; i++)
            if ( vtx[i] < 0 )  na--;
          ncor++;
        }
        break;
      }
    }
  }
  while ( ncor > 1 && na > 0 );

  E_pop();
  return(na);
}
