#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define LADMI  1.4143

int analar(pSurfMesh sm,double angdev,int *alert) {
  pHashtable  pht;
  pTriangle   pt;
  pPoint      p0,p1;
  double      dd,hmin2,rap,tail,ux,uy,uz;
  int         i,i1,i2,k,kk,ii,na,nb,s,ncor,vtx[3],inp[3];

  /* default */
  E_put("analar");
  na = sm->np;
  hmin2 = 0.0;
  if ( opts.hmin > 0.0 )  hmin2 = 0.25*opts.hmin*opts.hmin;

  /* reset hash table */
  for (k=1; k<nhmax; k++)
    hash[k].ind = hash[k].elt = 0;

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    pt->flag2 = 0;
  }

  /* analyze edge length */
  *alert = 0;
  na = 0;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    pt->flag1 = sm->mark+1;

    for (i=0; i<3; i++) {
      i1 = idir[i+1];
      i2 = idir[i+2];
      if ( pt->tag[i] & M_REQUIRED )  continue;
      /*else if ( pt->adj[i] > k )  continue;*/

      p0 = &sm->point[pt->v[i1]];
      p1 = &sm->point[pt->v[i2]];

      ux = p1->c[0] - p0->c[0];
      uy = p1->c[1] - p0->c[1];
      uz = p1->c[2] - p0->c[2];
      dd = ux*ux + uy*uy + uz*uz;
      if ( dd < hmin2 )  continue;

      /* compute length */
      dd = sqrt(dd);
      rap = (p1->size - p0->size) / p0->size;
      if ( fabs(rap) < EPS )
        tail = dd * (2.-EPS) / (2.*p0->size);
      else {
        /*
        tail  = 1.0/p0->size + 1.0/p1->size + 8.0 / (p0->size+p1->size);
        tail *= dd / 6.0;
        */
        tail = max(dd/p0->size,dd/p1->size);
      }
      if ( tail < LADMI )  continue;

      nb = (int)(tail+0.5);
      if ( nb*(nb+1) < 0.99*tail*tail )  nb++;
      if ( nb < 1 )  continue;

      /* split edge */
      pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
      if ( !pht ) {
        yerr.inderr[0] = pt->v[i1];
        yerr.inderr[1] = pt->v[i2];
        prierr(ERR,1015);
        exit(1);
      }
      else if ( pht->ind ) continue;

      if ( !addver(sm,k,i,pht,0.5) ) {
        *alert = 1;
        return(na);
      }
      na++;
    }
  }

  /* checking validity */
  do {
    ncor = 0;
    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;
      /* analyze edges */
      s = 0;
      for (i=0; i<3; i++) {
        vtx[i] = inp[i] = 0;
        if ( pt->tag[i] & M_REQUIRED )  continue;
        i1 = idir[i+1];
        i2 = idir[i+2];
        pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
        
        if ( !pht )  continue;
        vtx[i] = pht->ind;
        inp[i] = pht->elt;
        if ( vtx[i] ) s++;
      }
      if ( pt->flag2 == s )  continue;
      pt->flag2 = s;
      if ( !pt->flag2 )  continue;

      switch (s) {
      case 1:
        for (i=0; i<3; i++) {
          if ( !vtx[i] )  continue;
          if ( !chkspl1(sm,k,i,vtx,inp,angdev) ) {
            na--;
            ncor++;
          }
          break;
        }
        break;

      case 2:
        for (i=0; i<3; i++) {
          if ( vtx[i] ) continue;
          if ( !chkspl2(sm,k,i,vtx,inp,angdev) ) {
            if ( vtx[idir[i+1]] < 0 )  na--;
            if ( vtx[idir[i+2]] < 0 )  na--;
            ncor++;
          }
          break;
        }
        break;

      case 3:
        if ( !chkspl3(sm,k,vtx,inp,angdev) ) {
          for (i=0; i<3; i++)
            if ( vtx[i] < 0 )  na--;
          ncor++;
        }
        break;
      }
    }
  }
  while ( ncor > 1 && na > 0 );

  E_pop();
  return(na);
}
