#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


/* build free list of points */
int freelist(pSurfMesh sm) {
  pPoint   ppt;
  int      k,nl;

  nl = 0;
  sm->point[0].tmp = sm->np+1;
  for (k=sm->np; k>=1; k--) {
    ppt = &sm->point[k];
    if ( ppt->tag & M_UNUSED ) {
      ppt->tmp         = sm->point[0].tmp;
      sm->point[0].tmp = k;
      nl++;
    }
  }
  for (k=sm->np+1; k<sm->npmax; k++) {
    ppt = &sm->point[k];
    ppt->tmp = k+1;
    nl++;
  }
  sm->point[sm->npmax].tmp = 0;
  return(nl);
}


/* add new vertex on surface */
int addver(pSurfMesh sm,int k,int i,pHashtable pht,double t) {
  pPoint      p0,p1,ppt;
  pTriangle   pt;
  pMetric     pm0,pm1,pm;
  pGeomSupp   go;
  pGeomtge    tg;
  double      dd,t1 = 1.0-t;
  float      *n1,*n2;
  int         ifree,i1,i2,m,ret;

  /* get free address */
  /* 
  ifree = sm->point[0].tmp;
  if ( !ifree || ifree > sm->npmax-1 ) {
    yerr.inderr[0] = sm->np;
    yerr.inderr[1] = sm->npmax;
    prierr(WAR,4000);
    return(0);
  }
  else if ( ifree > sm->np ) {
    sm->np++;
  }
  sm->point[0].tmp = sm->point[ifree].tmp;
   */

  if ( sm->np > sm->npmax-1 ) {
    yerr.inderr[0] = sm->np;
    yerr.inderr[1] = sm->npmax;
    prierr(WAR,4000);
    return(0);
  }

  i1 = idir[i+1];
  i2 = idir[i+2];
  pt = &sm->tria[k];
  p0 = &sm->point[pt->v[i1]];
  p1 = &sm->point[pt->v[i2]];

  /* new point */
  ifree = ++sm->np;
  ppt   = &sm->point[ifree];
  ppt->tag   = pt->tag[i];
  ppt->ref   = 0;
  ppt->color = sm->mark;
  ppt->geom  = M_CURVE;
	if ( pt->edg[i] > 0 )  ppt->ref = pt->edg[i];

  /* size/metric interpolation */
  ppt->size = (float)(t1*p0->size + t*p1->size);
  if ( !(opts.ctrl & ISO) && sm->metric ) {
    pm0= &sm->metric[pt->v[i1]];
    pm1= &sm->metric[pt->v[i2]];
    pm = &sm->metric[sm->np];
    if ( !intme2_a(pm0,pm1,pm,t) ) {
      for (m=0; m<6; m++)
        pm->m[m] = t1*pm0->m[m] + t*pm1->m[m];
    }
  }

  /* compute point coords */
  ret = 0;
  if ( pt->tag[i] == M_NOTAG ) {
    /* check memory */
    if ( sm->nv > sm->nvmax-3 && !zaldy3(sm,1) ) {
      yerr.coderr = 4000;
      return(0);
    }
    if ( sm->dim == 2 )  ppt->geom = M_PLANAR;
    go = &sm->geom[++sm->nv];
    go-> gap = 1.0f;
    pht->elt = sm->nv;
    if ( sm->type & M_QUERY )
      ret = coorpo(sm,k,i,ppt->c,t,go->vn);
    if ( !ret ) {
      ppt->c[0] = t1*p0->c[0] + t*p1->c[0];
      ppt->c[1] = t1*p0->c[1] + t*p1->c[1];
      ppt->c[2] = t1*p0->c[2] + t*p1->c[2];
      /* update normal */
      n1 = sm->geom[pt->vn[i1]].vn;
      n2 = sm->geom[pt->vn[i2]].vn;
      go->vn[0] = t1*n1[0] + t*n2[0];
      go->vn[1] = t1*n1[1] + t*n2[1];
      go->vn[2] = t1*n1[2] + t*n2[2];
    }
  }

  else {
    /* check memory */
    if ( sm->nt > sm->ntmax-3 && !zaldy3(sm,2) ) {
      yerr.coderr = 4000;
      return(0);
    }
    tg = &sm->tgte[++sm->nt];
    pht->elt = 0;
    ppt->tge = sm->nt;
    if ( sm->type & M_QUERY )
      ret = coorpo(sm,k,i,ppt->c,t,tg->t);
    if ( !ret ) {
      ppt->c[0] = t1*p0->c[0] + t*p1->c[0];
      ppt->c[1] = t1*p0->c[1] + t*p1->c[1];
      ppt->c[2] = t1*p0->c[2] + t*p1->c[2];

      /* update tangent */    
      tg->t[0] = p1->c[0] - p0->c[0];
      tg->t[1] = p1->c[1] - p0->c[1];
      tg->t[2] = p1->c[2] - p0->c[2];
      dd = sqrt(tg->t[0]*tg->t[0] + tg->t[1]*tg->t[1] + tg->t[2]*tg->t[2]);
      if ( dd > 0.0f ) {
        tg->t[0] /= dd;
        tg->t[1] /= dd;
        tg->t[2] /= dd;
      }
    }
  }

  pht->ind = sm->np;

  return(1);
}
