#!/bin/bash
set -eu


VER="3300100"

# Cleanup
rm -rf install src
mkdir install src

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/sqlite-autoconf-${VER}.tar.gz" "sqlite-autoconf-${VER}.tar.gz"

# Unpack source
tar -zxvf sqlite-autoconf-$VER.tar.gz

# Move source into 'src' directory
mv sqlite-autoconf-$VER/* src
rm -rf sqlite-autoconf-$VER

# Configure
cd src
./configure \
	--prefix="${ISSM_DIR}/externalpackages/sqlite/install"

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
