%SOLIDEARTHSOLUTION class definition
%
%   Usage:
%      solidearthsolution=solidearthsolution();

classdef solidearthsolution
	properties (SetAccess=public) 
		displacementeast = [];
		displacementnorth =[];
		displacementup=[];
		geoid=[];
		barystaticsealevel=[];
	end
	methods
		function self = solidearthsolution(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = setdefaultparameters(self) % {{{
	
			self.displacementeast = [];
			self.displacementnorth =[];
			self.displacementup=[];
			self.geoid=[];
			self.barystaticsealevel=[];
	
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','solidearth.external.displacementeast','Inf',1,'timeseries',1);
			md = checkfield(md,'fieldname','solidearth.external.displacementnorth','Inf',1,'timeseries',1);
			md = checkfield(md,'fieldname','solidearth.external.displacementup','Inf',1,'timeseries',1);
			md = checkfield(md,'fieldname','solidearth.external.geoid','Inf',1,'timeseries',1);
			md = checkfield(md,'fieldname','solidearth.external.barystaticsealevel','Inf',1,'timeseries',1);

		end % }}}
		function disp(self) % {{{
			disp(sprintf('%s','         units for time series is (yr)'));
			fielddisplay(self,'displacementeast','solid-Earth Eastwards bedrock displacement series (m)');
			fielddisplay(self,'displacementnorth','solid-Earth Northwards bedrock displacement time series (m)');
			fielddisplay(self,'displacementup','solid-Earth bedrock uplift time series (m)');
			fielddisplay(self,'geoid','solid-Earth geoid time series (m)');
			fielddisplay(self,'barystaticsealevel','barystatic absolute sea-level time series (m)');

		end % }}}
		function marshall(self,prefix,md,fid) % {{{
			yts=md.constants.yts;

			%transform our time series into time series rates 
			time=self.displacementeast(end,:);
			dt=diff(time,1,2);
			
			displacementeast_rate=diff(displacementeast(1:end-1,:),1,2)./dt;
			displacementnorth_rate=diff(displacementnorth(1:end-1,:),1,2)./dt;
			displacementup_rate=diff(displacementup(1:end-1,:),1,2)./dt;
			geoid_rate=diff(geoid(1:end-1,:),1,2)./dt;
			barystaticsealevel_rate=diff(barystaticsealevel(1:end-1,:),1,2)./dt;

			WriteData(fid,prefix,'name','md.solidearth.external.displacementeast','data',displacementeast_rate,'format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
			WriteData(fid,prefix,'name','md.solidearth.external.displacementup','data',displacementup_rate,'format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
			WriteData(fid,prefix,'name','md.solidearth.external.displacementnorth','data',displacementnorth_rate,'format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
			WriteData(fid,prefix,'name','md.solidearth.external.geoid','data',geoid_rate,'format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
			WriteData(fid,prefix,'name','md.solidearth.external.barystaticsealevel','data',barystaticsealevel_rate,'format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
	
		end % }}}
		function savemodeljs(self,fid,modelname) % {{{
			writejs1Darray(fid,[modelname '.solidearth.external.displacementeast'],self.displacementeast);
			writejs1Darray(fid,[modelname '.solidearth.external.displacementnorth'],self.displacementnorth);
			writejs1Darray(fid,[modelname '.solidearth.external.displacementup'],self.displacementup);
			writejs1Darray(fid,[modelname '.solidearth.external.geoid'],self.geoid);
			writejs1Darray(fid,[modelname '.solidearth.external.barystaticsealevel'],self.barystaticsealevel);
		end % }}}
		function self = extrude(self,md) % {{{
		end % }}}
	end
end
