#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.7.6 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://issm.ess.uci.edu/files/externalpackages/petsc-lite-3.7.6.tar.gz' 'petsc-3.7.6.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.7.6.tar.gz
mv petsc-3.7.6/* src/
rm -rf petsc-3.7.6

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-blas-lapack-dir="/usr/local/intel/2020/compilers_and_libraries_2020.0.166/linux/mkl/" \
	--with-mpi-lib="/usr/local/sgi/mpi/mpt-2.17/lib/libmpi.so" \
	--with-mpi-include="/usr/local/sgi/mpi/mpt-2.17/include/" \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 \
	--download-scalapack=1 

#prepare script to reconfigure petsc
cat > script.queue << EOF
#!/bin/bash
#SBATCH -J petscinstall # Job Name
#SBATCH -N 1
#SBATCH -n 1
#SBATCH -A s1690
#SBATCH -t 00:01:00 # Run time (hh:mm:ss) - 1.5 hours
#SBATCH --qos=debug
#SBATCH -o petscinstall.outlog
#SBATCH -e petscinstall.errlog

. /usr/share/modules/init/bash
module purge
module load comp/intel/20.0.0.166
module load mpi/sgi-mpt/2.17
module load cmake/3.17.0

export PATH="$PATH:."
export MPI_GROUP_MAX=64
mpiexec -np 1 ./conftest-arch-linux2-c-opt
EOF

#print instructions
echo "== Now: cd src/ "
echo "== sbatch script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
