#!/bin/bash
set -eu


# TODO:
# - Revisit enviroment variables (especially EMCC_CFLAGS) once support for
#	Fortran has been accomplished.
#

# Constants
#
export PREFIX="${ISSM_DIR}/triangle/install" # Set to location where external package should be installed

# Environment
#
export CC=emcc
export CXX=em++
export AR=emar
export RANLIB=emranlib
#export EMCC_DEBUG=1 # Uncomment to enable debugging
export EMCC_CFLAGS="-s ERROR_ON_UNDEFINED_SYMBOLS=0" # Required after v1.38.14 to avoid undefined symbol warnings from our Fortran object files being treated as errors

# Source Emscripten environment
source ${EMSCRIPTEN_ROOT}/emsdk_env.sh

# Cleanup
rm -rf ${INSTALL_DIR} src
mkdir ${INSTALL_DIR} ${INSTALL_DIR}/include ${INSTALL_DIR}/share src

# Download source
${ISSM_DIR}/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/triangle.zip" "triangle.zip"

# Unpack source
unzip triangle.zip -d src

# Copy customized source files to 'src' directory
cp configs/makefile src
cp configs/javascript/configure.make src
cp configs/javascript/triangle.h src

# Compile
cd src
make objects

# Install
cd ..
cp src/triangle.o ${INSTALL_DIR}/share
cp src/triangle.h ${INSTALL_DIR}/include
