#!/bin/bash
set -eu


## Constants
#
VER="3.12.3"

PETSC_DIR=${ISSM_DIR}/externalpackages/petsc/src # DO NOT CHANGE THIS
PREFIX="${ISSM_DIR}/externalpackages/petsc/install" # Set to location where external package should be installed

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/petsc-lite-${VER}.tar.gz" "petsc-${VER}.tar.gz"

# Unpack source
tar -zxvf petsc-${VER}.tar.gz

# Cleanup
rm -rf ${PREFIX} ${PETSC_DIR}
mkdir -p ${PREFIX} ${PETSC_DIR}

# Move source to $PETSC_DIR
mv petsc-${VER}/* ${PETSC_DIR}
rm -rf petsc-${VER}

# Configure
#
# NOTE:
# - Cannot use --with-fpic option when compiling static libs,
#
#		Cannot determine compiler PIC flags if shared libraries is turned off
#		Either run using --with-shared-libraries or --with-pic=0 and supply the
#		compiler PIC flag via CFLAGS, CXXXFLAGS, and FCFLAGS
#
# - Added -Wno-error=implicit-function-declaration to CFLAGS for Clang >= 12. 
#	(may need to remove it for earlier versions not using the C99 standard).
# - Added -fallow-argument-mismatch to FFLAGS in order to clear,
#
#		error: The Fortran compiler gfortran will not compile files that call 
#		the same routine with arguments of different types.
#
#	for gfortran 10 or later (may need to remove it for earlier versions).
# - Added -static-libgfortran to all macOS static builds, but this will not 
#	work out of the box on Linux.
#
cd ${PETSC_DIR}
./config/configure.py \
	--prefix="${PREFIX}" \
	--PETSC_DIR="${PETSC_DIR}" \
	--with-shared-libraries=0 \
	--CFLAGS="-fPIC -Wno-error=implicit-function-declaration" \
	--CXXFLAGS="-fPIC" \
	--FFLAGS="-fPIC -fallow-argument-mismatch -static-libgfortran" \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--download-fblaslapack=1 \
	--download-mpich=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-scalapack=1 \
	--download-mumps=1 \
	--download-zlib=1 \
	--download-hdf5=1

# Compile and install
make
make install
