#!/bin/bash
set -eu


## TODO
#	- May want to supply path to Python instead of, effectively, using result of `which python`
#

## Constants
#
VER="3.1.1"

## Environment
#
export CC=mpicc
export CXX=mpicxx
export LDFLAGS="-L${HDF5_ROOT}/lib" # Need to do this so HDF5 symbols referenced in NETCDF library are found at link time
export LIBS="-lhdf5_hl -lhdf5" # Need to do this so HDF5 symbols referenced in NETCDF library are found at link time
export PREFIX="${ISSM_DIR}/externalpackages/gdal/install" # Need this to properly set destination root for Python libraries on macOS (should not affect Linux build; do not need for this configuration, but including it for consistency)

# Cleanup
rm -rf ${PREFIX} src
mkdir -p ${PREFIX} src

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "http://issm.jpl.nasa.gov/files/externalpackages/gdal-${VER}.tar.gz" "gdal-${VER}.tar.gz"

# Unpack source
tar -zxvf gdal-${VER}.tar.gz

# Move source into 'src' directory
mv gdal-${VER}/* src
rm -rf gdal-${VER}

# Configure
cd src
./configure \
	--prefix="${PREFIX}" \
	--enable-fast-install \
	--disable-shared \
	--without-ld-shared \
	--enable-static \
	--with-pic \
	--with-python \
	--with-libz="${ZLIB_ROOT}" \
	--with-hdf5="${HDF5_ROOT}" \
	--with-netcdf="${NETCDF_ROOT}" \
	--with-proj="${PROJ_ROOT}" \
	--with-pg=no

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
