#!/bin/bash
set -eu


## Constants
#
VER="3.19.1"

PREFIX="${ISSM_DIR}/externalpackages/cmake/install" # Set to location where external package should be installed

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/cmake-${VER}.tar.gz" "cmake-${VER}.tar.gz"

# Unpack source
tar -zxvf cmake-${VER}.tar.gz

# Cleanup
rm -rf ${PREFIX}

# Move source into target directory
mv cmake-${VER} ${PREFIX}

# Configure
cd ${PREFIX}
#./bootstrap \
#	--prefix=${PREFIX} # Breaks on ronne
./configure \
	--prefix=${PREFIX}

# Compile
if [ $# -eq 0 ]; then
	make
else
	make -j $1;
fi
