#!/bin/bash
set -eu


# Constants
#
VER="3.1.1"

HDF5_ROOT="${ISSM_DIR}/externalpackages/petsc/install"
NETCDF_ROOT="${ISSM_DIR}/externalpackages/netcdf/install"
PROJ_ROOT="${ISSM_DIR}/externalpackages/proj/install"
ZLIB_ROOT="${ISSM_DIR}/externalpackages/petsc/install"

## Environment
#
export PREFIX="${ISSM_DIR}/externalpackages/gdal/install" # Need this to properly set destination root for Python libraries on macOS (should not affect Linux build; do not need for this configuration, but including it for consistency)

# Cleanup
rm -rf install src
mkdir install src

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "http://issm.jpl.nasa.gov/files/externalpackages/gdal-${VER}.tar.gz" "gdal-${VER}.tar.gz"

# Unpack source
tar -zxvf gdal-$VER.tar.gz

# Move source into 'src' directory
mv gdal-$VER/* src
rm -rf gdal-$VER

# Configure
cd src
./configure \
	--prefix="${PREFIX}" \
	--enable-fast-install \
	--with-libz="${ZLIB_ROOT}" \
	--with-hdf5="${HDF5_ROOT}" \
	--with-netcdf="${NETCDF_ROOT}" \
	--with-proj="${PROJ_ROOT}"

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
