/* A lexical scanner generated by flex*/

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.91 96/09/10 16:58:48 vern Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define nidrconst const
#else
#define nidrconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN nidr_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((nidr_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE nidrrestart( nidrin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct nidr_buffer_state *YY_BUFFER_STATE;

extern int nidrleng;
extern FILE *nidrin, *nidrout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		nidrless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the nidrless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define nidrless(n) \
	do \
		{ \
		/* Undo effects of setting up nidrtext. */ \
		*nidr_cp = nidr_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		nidr_c_buf_p = nidr_cp = nidr_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up nidrtext again */ \
		} \
	while ( 0 )

#define unput(c) nidrunput( c, nidrtext_ptr )

/* Some routines like nidr_flex_realloc() are emitted as static but are
   not called by all lexers. This generates warnings in some compilers,
   notably GCC. Arrange to suppress these. */
#ifdef __GNUC__
#define YY_MAY_BE_UNUSED __attribute__((unused))
#else
#define YY_MAY_BE_UNUSED
#endif

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int nidr_size_t;


struct nidr_buffer_state
	{
	FILE *nidr_input_file;

	char *nidr_ch_buf;		/* input buffer */
	char *nidr_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	nidr_size_t nidr_buf_size;

	/* Number of characters read into nidr_ch_buf, not including EOB
	 * characters.
	 */
	int nidr_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int nidr_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int nidr_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int nidr_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int nidr_fill_buffer;

	int nidr_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via nidrrestart()), so that the user can continue scanning by
	 * just pointing nidrin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE nidr_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER nidr_current_buffer


/* nidr_hold_char holds the character lost when nidrtext is formed. */
static char nidr_hold_char;

static int nidr_n_chars;		/* number of characters read into nidr_ch_buf */


int nidrleng;

/* Points to current character in buffer. */
static char *nidr_c_buf_p = (char *) 0;
static int nidr_init = 1;		/* whether we need to initialize */
static int nidr_start = 0;	/* start state number */

/* Flag which is used to allow nidrwrap()'s to do buffer switches
 * instead of setting up a fresh nidrin.  A bit of a hack ...
 */
static int nidr_did_buffer_switch_on_eof;

void nidrrestart YY_PROTO(( FILE *input_file ));

void nidr_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void nidr_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE nidr_create_buffer YY_PROTO(( FILE *file, int size ));
void nidr_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void nidr_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void nidr_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER nidr_flush_buffer( nidr_current_buffer )

YY_BUFFER_STATE nidr_scan_buffer YY_PROTO(( char *base, nidr_size_t size ));
YY_BUFFER_STATE nidr_scan_string YY_PROTO(( nidrconst char *nidr_str ));
YY_BUFFER_STATE nidr_scan_bytes YY_PROTO(( nidrconst char *bytes, int len ));

static void *nidr_flex_alloc YY_PROTO(( nidr_size_t ));
static void *nidr_flex_realloc YY_PROTO(( void *, nidr_size_t )) YY_MAY_BE_UNUSED;
static void nidr_flex_free YY_PROTO(( void * ));

#define nidr_new_buffer nidr_create_buffer

#define nidr_set_interactive(is_interactive) \
	{ \
	if ( ! nidr_current_buffer ) \
		nidr_current_buffer = nidr_create_buffer( nidrin, YY_BUF_SIZE ); \
	nidr_current_buffer->nidr_is_interactive = is_interactive; \
	}

#define nidr_set_bol(at_bol) \
	{ \
	if ( ! nidr_current_buffer ) \
		nidr_current_buffer = nidr_create_buffer( nidrin, YY_BUF_SIZE ); \
	nidr_current_buffer->nidr_at_bol = at_bol; \
	}

#define YY_AT_BOL() (nidr_current_buffer->nidr_at_bol)

typedef unsigned char YY_CHAR;
FILE *nidrin = (FILE *) 0, *nidrout = (FILE *) 0;
typedef int nidr_state_type;
extern char *nidrtext;
#define nidrtext_ptr nidrtext

static nidr_state_type nidr_get_previous_state YY_PROTO(( void ));
static nidr_state_type nidr_try_NUL_trans YY_PROTO(( nidr_state_type current_state ));
static int nidr_get_next_buffer YY_PROTO(( void ));
static void nidr_fatal_error YY_PROTO(( nidrconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up nidrtext.
 */
#define YY_DO_BEFORE_ACTION \
	nidrtext_ptr = nidr_bp; \
	nidrtext_ptr -= nidr_more_len; \
	nidrleng = (int) (nidr_cp - nidrtext_ptr); \
	nidr_hold_char = *nidr_cp; \
	*nidr_cp = '\0'; \
	nidr_c_buf_p = nidr_cp;

#define YY_NUM_RULES 27
#define YY_END_OF_BUFFER 28
static nidrconst short int nidr_accept[125] =
    {   0,
        0,    0,    0,    0,   21,   21,   18,   18,   28,    6,
        5,    2,   25,    4,    3,    3,    6,   16,   12,    2,
       15,   25,   13,   26,   16,    8,   16,    9,   14,    7,
       11,   11,   11,   16,   21,   21,   22,   22,   21,   21,
       18,   18,   19,   18,   19,   18,    5,   25,    0,   25,
       25,    4,   24,    3,    3,    0,   23,   12,    8,    7,
        0,    9,    0,    0,   10,    9,    9,    9,    7,   11,
       11,   11,   21,   21,   21,   21,   20,   21,   21,   21,
       18,   18,   18,   18,   18,   18,   17,   18,   24,    3,
        0,    0,   10,   10,    9,   10,    9,    9,   10,   10,

       10,   21,   18,    1,   10,   10,   10,   10,   10,    9,
       10,   11,    0,   10,   10,   11,    0,   11,    0,   11,
        0,   10,   10,    0
    } ;

static nidrconst int nidr_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    1,    1,    1,    6,    1,
        1,    7,    8,    9,   10,   11,    1,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,    7,   13,    1,
       14,    1,    1,   15,   16,   17,   17,   17,   18,   19,
       17,   17,   20,   17,   17,   17,   17,   21,   17,   17,
       17,   17,   17,   22,   17,   17,   17,   23,   24,   17,
        1,   25,    1,    1,   26,    1,   16,   17,   17,   17,

       18,   19,   17,   17,   20,   17,   17,   17,   17,   21,
       17,   17,   17,   17,   17,   22,   17,   17,   17,   23,
       24,   17,    1,    1,    1,   15,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static nidrconst int nidr_meta[27] =
    {   0,
        1,    1,    2,    3,    1,    4,    1,    5,    1,    6,
        6,    6,    1,    1,    7,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    1,    6
    } ;

static nidrconst short int nidr_base[137] =
    {   0,
        0,    0,   26,    0,   51,   75,   99,  123,  263,  264,
       56,  264,   57,  264,    0,  239,   57,  264,  147,  264,
      264,  236,  264,  264,  162,  264,  248,   53,  264,  257,
        0,  237,  241,   64,    0,   67,  264,  252,   59,   71,
        0,   81,  264,   62,  249,   86,   88,  229,   92,  228,
       86,  227,  249,    0,  230,   94,  264,    0,  264,  247,
      236,   96,  226,  230,   91,  233,   98,  107,  242,    0,
      224,  212,    0,  116,  108,  120,  264,  126,  226,  129,
        0,  132,  114,  133,  121,  224,  264,  140,  217,  191,
      193,  178,  169,  150,  168,  126,  155,  167,  166,  157,

        0,  174,  173,    0,  151,  264,  158,  157,  156,  147,
      143,  133,  132,  138,  135,  125,  120,   76,   63,   51,
       33,    0,  264,  264,  183,  190,  197,  199,  202,  203,
      210,  217,  224,  231,  234,  236
    } ;

static nidrconst short int nidr_def[137] =
    {   0,
      124,    1,  124,    3,  125,  125,  126,  126,  124,  124,
      124,  124,  127,  124,  128,  128,  124,  124,  124,  124,
      124,  127,  124,  124,  124,  124,  124,  129,  124,  124,
      130,  130,  130,  124,  131,  131,  124,  124,  132,  131,
      133,  133,  124,  134,  124,  133,  124,  127,  124,  127,
      127,  127,  124,  128,  128,  124,  124,   19,  124,  124,
      124,  129,  124,  124,  135,  129,  136,  129,  124,  130,
      130,  130,  131,  131,  132,  131,  124,  132,  131,  131,
      133,  133,  134,  133,  134,  133,  124,  133,  124,  128,
      124,  124,  135,  135,  136,  135,  136,  129,  135,  130,

      130,  131,  133,  128,  124,  124,  135,  135,  135,  136,
      135,  130,  124,  135,  135,  130,  124,  130,  124,  130,
      124,  130,  124,    0,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124
    } ;

static nidrconst short int nidr_nxt[291] =
    {   0,
       10,   11,   12,   10,   13,   10,   10,   10,   10,   10,
       10,   10,   14,   10,   10,   15,   15,   16,   15,   15,
       15,   15,   15,   15,   17,   10,   18,   19,   20,   21,
       22,   23,   24,   25,   26,   25,   27,   28,   29,   30,
       18,   31,   31,   31,   31,   32,   33,   31,   31,   31,
       34,   18,   36,   37,   38,   39,  123,   47,   56,   57,
       48,   51,   50,   67,   62,   56,   57,   50,   74,   52,
       68,   75,   80,   57,  122,   40,   36,   37,   38,   39,
       49,   53,   82,   79,  121,   83,   86,   88,   57,   47,
       51,   76,   48,   56,   57,   56,   57,  120,   52,   40,

       42,   43,   65,   44,   45,   84,   67,   62,   94,   96,
       53,   50,   49,   68,   98,   97,   98,   74,   99,   50,
       75,   80,   57,   46,   42,   43,   50,   44,   45,   50,
       80,   57,   79,   82,   88,   57,   83,   96,   86,  119,
       76,   88,   57,  109,  118,   86,  115,   46,   58,  115,
       79,   48,  117,  116,  111,   59,   84,  107,  111,  107,
       60,  108,  110,  114,  110,  114,  111,  115,  108,  108,
      113,   49,   61,   62,  103,  102,  112,   99,   99,  124,
      124,   63,   64,   35,   35,   35,   35,   35,   35,   35,
       41,   41,   41,   41,   41,   41,   41,   50,  106,   50,

       50,   50,   50,   50,   54,   54,   66,   66,   70,   70,
       73,  105,  104,   73,   73,   73,   73,   78,   89,   78,
       78,   78,   78,   78,   81,  103,   81,  102,   81,   81,
       81,   85,  101,   85,   85,   85,   85,   85,   93,   93,
       95,   95,  100,   69,  124,   92,   91,   65,   69,   90,
       89,   53,   53,   53,   87,   77,   72,   71,   69,   65,
       53,   55,  124,    9,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124
    } ;

static nidrconst short int nidr_chk[291] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    5,    5,    5,    5,  121,   11,   17,   17,
       11,   13,   39,   28,   28,   34,   34,   44,   36,   13,
       28,   36,   40,   40,  120,    5,    6,    6,    6,    6,
       11,   13,   42,   39,  119,   42,   44,   46,   46,   47,
       51,   36,   47,   49,   49,   56,   56,  118,   51,    6,

        7,    7,   65,    7,    7,   42,   62,   62,   65,   67,
       51,   75,   47,   62,   68,   67,   68,   74,   68,   83,
       74,   76,   76,    7,    8,    8,   85,    8,    8,   78,
       80,   80,   75,   82,   84,   84,   82,   96,   83,  117,
       74,   88,   88,   96,  116,   85,  115,    8,   19,  114,
       78,   19,  113,  112,  111,   19,   82,   94,  110,   94,
       19,   94,   97,  109,   97,  109,   97,  109,  108,  107,
      105,   19,   25,   25,  103,  102,  100,   99,   98,   95,
       93,   25,   25,  125,  125,  125,  125,  125,  125,  125,
      126,  126,  126,  126,  126,  126,  126,  127,   92,  127,

      127,  127,  127,  127,  128,  128,  129,  129,  130,  130,
      131,   91,   90,  131,  131,  131,  131,  132,   89,  132,
      132,  132,  132,  132,  133,   86,  133,   79,  133,  133,
      133,  134,   72,  134,  134,  134,  134,  134,  135,  135,
      136,  136,   71,   69,   66,   64,   63,   61,   60,   55,
       53,   52,   50,   48,   45,   38,   33,   32,   30,   27,
       22,   16,    9,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124
    } ;

static nidr_state_type nidr_last_accepting_state;
static char *nidr_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
static int nidr_more_flag = 0;
static int nidr_more_len = 0;
#define nidrmore() (nidr_more_flag = 1)
#define YY_MORE_ADJ nidr_more_len
#define YY_RESTORE_YY_MORE_OFFSET
char *nidrtext;
/* #line 1 "nidrscan.l" */
#define INITIAL 0
/* #line 2 "nidrscan.l" */
/*********************************************************************
Copyright 2008, 2010 Sandia Corporation.  Under the terms of Contract
DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government
retains certain rights in this software.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

* Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

* Neither the name of Sandia Corporation nor the names of its
contributors may be used to endorse or promote products derived from
this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***********************************************************************/

#ifndef NIDR_H
#include "nidr.h"
#endif
#ifndef NIDR_PARSER_H
#include "nidr-parser.h"
#endif
#include <stdlib.h>	/* possibly redundant, but necessary for strtod on some systems */

static int my_nidr_input(char*, int);
extern char *nidr_KWscopy(const char*);

#ifdef IDR_DEBUG
static void print_token( char*, char*, char* );
#else
#define print_token(a,b,c) /*nothing*/
#endif


#define YY_INPUT(buf,result,maxsize) result = my_nidr_input(buf,maxsize)

int	nidrLineNumber = 1;

extern void	nidr_abort(void);
extern void	(*nidr_comment)(const char*);
extern KeyWord *(*nidr_identifier)(const char*);
extern KeyWord *nidr_keyword(const char*);
extern const char *nidr_keyword_name(void);
/* Hardwire the now rarely used help text.  It truly is something the
   application should provide, not NIDR, but had trouble with the
   declaration/definition w.r.t. MSVS when building DAKOTA source.
   Ultimately would want to pass it into nidr_parse(...) 
extern char	nidr_please_refer[];
*/
char nidr_please_refer[] = 
  "Please refer to the input specification reference for this application.";
extern void	nidr_tolower(char*);
static void	bad_number(const char*);
static void	unput_string(char *, int);
#define DATA 1

#define DQ_STRING 2

#define Q_STRING 3

/* #line 545 "nidr-scanner.c" */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int nidrwrap YY_PROTO(( void ));
#else
extern int nidrwrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void nidrunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef nidrtext_ptr
static void nidr_flex_strncpy YY_PROTO(( char *, nidrconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int nidr_flex_strlen YY_PROTO(( nidrconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int nidrinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int nidr_start_stack_ptr = 0;
static int nidr_start_stack_depth = 0;
static int *nidr_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void nidr_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void nidr_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int nidr_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( nidrtext, nidrleng, 1, nidrout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( nidr_current_buffer->nidr_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( nidrin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( nidrin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, nidrin )) == 0) \
		  && ferror( nidrin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "nidrterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef nidrterminate
#define nidrterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) nidr_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int nidrlex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after nidrtext and nidrleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register nidr_state_type nidr_current_state;
	register char *nidr_cp = NULL, *nidr_bp = NULL;
	register int nidr_act;

/* #line 85 "nidrscan.l" */



	KeyWord	*identifier, *keyword;
	char *se;


/* #line 704 "nidr-scanner.c" */

	if ( nidr_init )
		{
		nidr_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! nidr_start )
			nidr_start = 1;	/* first start state */

		if ( ! nidrin )
			nidrin = stdin;

		if ( ! nidrout )
			nidrout = stdout;

		if ( ! nidr_current_buffer )
			nidr_current_buffer =
				nidr_create_buffer( nidrin, YY_BUF_SIZE );

		nidr_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		nidr_more_len = 0;
		if ( nidr_more_flag )
			{
			nidr_more_len = nidr_c_buf_p - nidrtext_ptr;
			nidr_more_flag = 0;
			}
		nidr_cp = nidr_c_buf_p;

		/* Support of nidrtext. */
		*nidr_cp = nidr_hold_char;

		/* nidr_bp points to the position in nidr_ch_buf of the start of
		 * the current run.
		 */
		nidr_bp = nidr_cp;

		nidr_current_state = nidr_start;
nidr_match:
		do
			{
			register YY_CHAR nidr_c = nidr_ec[YY_SC_TO_UI(*nidr_cp)];
			if ( nidr_accept[nidr_current_state] )
				{
				nidr_last_accepting_state = nidr_current_state;
				nidr_last_accepting_cpos = nidr_cp;
				}
			while ( nidr_chk[nidr_base[nidr_current_state] + nidr_c] != nidr_current_state )
				{
				nidr_current_state = (int) nidr_def[nidr_current_state];
				if ( nidr_current_state >= 125 )
					nidr_c = nidr_meta[(unsigned int) nidr_c];
				}
			nidr_current_state = nidr_nxt[nidr_base[nidr_current_state] + (unsigned int) nidr_c];
			++nidr_cp;
			}
		while ( nidr_base[nidr_current_state] != 264 );

nidr_find_action:
		nidr_act = nidr_accept[nidr_current_state];
		if ( nidr_act == 0 )
			{ /* have to back up */
			nidr_cp = nidr_last_accepting_cpos;
			nidr_current_state = nidr_last_accepting_state;
			nidr_act = nidr_accept[nidr_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( nidr_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*nidr_cp = nidr_hold_char;
			nidr_cp = nidr_last_accepting_cpos;
			nidr_current_state = nidr_last_accepting_state;
			goto nidr_find_action;

case 1:
YY_RULE_SETUP
/* #line 92 "nidrscan.l" */
{
			print_token("exit", NULL, "<INITIAL>" );
			return 0;
			}
	YY_BREAK
case 2:
YY_RULE_SETUP
/* #line 97 "nidrscan.l" */
{
			if (nidr_comment)
				nidr_comment(nidrtext);
			nidrLineNumber++;
			}
	YY_BREAK
case 3:
YY_RULE_SETUP
/* #line 103 "nidrscan.l" */
{
			nidr_tolower(nidrtext);
			keyword = nidr_keyword(nidrtext);

			if  (keyword) {
				print_token( "keyword", (char*) nidrtext, "<INITIAL>" );
				if (keyword->kind & KWKind_Dynmult)
					return END;
				nidrlval.keyword = keyword;
				BEGIN DATA;
				return KEY_WORD;
				}
			print_token( "error", (char*) nidrtext, "<INITIAL>" );
			nidrlval.string = nidrtext;
			return KEYWORDERROR;
			}
	YY_BREAK
case 4:
YY_RULE_SETUP
/* #line 120 "nidrscan.l" */
{
			if (*nidrtext == '#') {
				if (nidr_comment)
					nidr_comment(nidrtext);
				}
			else {
				print_token( "end", NULL, "<INITIAL>" );
				return END;
				}
			}
	YY_BREAK
case 5:
YY_RULE_SETUP
/* #line 131 "nidrscan.l" */
{ print_token( "whitespace", (char*) nidrtext, "<INITIAL>" ); }
	YY_BREAK
case 6:
YY_RULE_SETUP
/* #line 133 "nidrscan.l" */
{
			print_token( "word", (char*) nidrtext, "<INITIAL>" );
			nidrlval.string = nidr_KWscopy(nidrtext);
			return STRING;
			}
	YY_BREAK
case 7:
YY_RULE_SETUP
/* #line 138 "nidrscan.l" */
{
			print_token( "equals", NULL, "<DATA>" );
			return EQUALS;
			}
	YY_BREAK
case 8:
YY_RULE_SETUP
/* #line 142 "nidrscan.l" */
{
			print_token( "separator", NULL, "<DATA>" );
			return SEPARATOR;
			}
	YY_BREAK
case 9:
YY_RULE_SETUP
/* #line 146 "nidrscan.l" */
{
			print_token( "integer", (char*) nidrtext, "<DATA>" );
			/* The following, old way has trouble with */
			/* big floating-point numbers written without */
			/* a decimal point */
			/* nidrlval.integer = (int) atoi( (char*) nidrtext ); */
			/* return INTEGER; */
			nidrlval.real = strtod(nidrtext,&se);
			if (*se)
				bad_number(nidrtext);
			return REAL;
			}
	YY_BREAK
case 10:
YY_RULE_SETUP
/* #line 158 "nidrscan.l" */
{
			print_token( "real", (char*) nidrtext, "<DATA>" );
			nidrlval.real = strtod(nidrtext,&se);
			if (*se)
				bad_number(nidrtext);
			return REAL;
			}
	YY_BREAK
case 11:
YY_RULE_SETUP
/* #line 165 "nidrscan.l" */
{
			nidr_tolower(nidrtext);
			if (nidr_keyword(nidrtext)) {
				unput_string(nidrtext, nidrleng);
				BEGIN INITIAL;
				return END;
				}
			identifier = nidr_identifier(nidrtext);

			if (identifier) {
				print_token( "identifier", (char*) nidrtext, "<DATA>");

				nidrlval.identifier = identifier;
				return IDENTIFIER;
				}
			else {
				print_token( "word", (char*) nidrtext, "<DATA>" );
				fprintf(stderr,"\n\tunrecognized identifier '%s'\n", nidrtext);
				fprintf(stderr,"\tinput line %d, within %s keyword.\n",
						nidrLineNumber, nidr_keyword_name());
				fprintf(stderr, "%s\n", nidr_please_refer);
				nidr_abort();
				nidrlval.string = nidr_KWscopy(nidrtext);
				return STRING;
				}
			}
	YY_BREAK
case 12:
YY_RULE_SETUP
/* #line 192 "nidrscan.l" */
{ print_token( "whitespace", (char*) nidrtext, "<DATA>" ); }
	YY_BREAK
case 13:
YY_RULE_SETUP
/* #line 194 "nidrscan.l" */
{
			print_token( "opening quote", NULL, "<DATA>" );
			BEGIN Q_STRING;
			}
	YY_BREAK
case 14:
YY_RULE_SETUP
/* #line 198 "nidrscan.l" */
{
			print_token( "end", NULL, "<DATA>" );
			BEGIN INITIAL;
			return END;
			}
	YY_BREAK
case 15:
YY_RULE_SETUP
/* #line 203 "nidrscan.l" */
{
			print_token( "double quote", NULL, "<DATA>" );
			BEGIN DQ_STRING;
			}
	YY_BREAK
case 16:
YY_RULE_SETUP
/* #line 207 "nidrscan.l" */
{
			print_token( "word", (char*) nidrtext, "<DATA>" );
			fprintf(stderr, "Input line %d:  '%s' unexpected.\n",
				nidrLineNumber, nidrtext);
			nidr_abort();
			nidrlval.string = nidr_KWscopy(nidrtext);
			return STRING;
			}
	YY_BREAK
case 17:
YY_RULE_SETUP
/* #line 215 "nidrscan.l" */
{
			print_token( "q:repeated quote", NULL, "<Q_STRING>" );
			nidrtext[--nidrleng] = 0;
			nidrmore();
			}
	YY_BREAK
case 18:
YY_RULE_SETUP
/* #line 220 "nidrscan.l" */
{
			nidrmore();
			print_token( "q:text", (char*) nidrtext, "<Q_STRING>" );
			}
	YY_BREAK
case 19:
YY_RULE_SETUP
/* #line 224 "nidrscan.l" */
{
			print_token( "closing quote", NULL, "<Q_STRING>" );
			if (nidrtext[--nidrleng] == '\n')
				unput('\n');
			nidrtext[nidrleng] = 0;
			print_token( "quoted string", (char*) nidrtext, "<Q_STRING>" );
			nidrlval.qstring = nidr_KWscopy(nidrtext);
			BEGIN DATA;
			return QUOTED_STRING;
			}
	YY_BREAK
case 20:
YY_RULE_SETUP
/* #line 234 "nidrscan.l" */
{
			print_token( "q:repeated double quote", NULL, "<DQ_STRING>" );
			nidrtext[--nidrleng] = 0;
			nidrmore();
			}
	YY_BREAK
case 21:
YY_RULE_SETUP
/* #line 239 "nidrscan.l" */
{
			nidrmore();
			print_token( "q:text", (char*) nidrtext, "<DQ_STRING>" );
			}
	YY_BREAK
case 22:
YY_RULE_SETUP
/* #line 243 "nidrscan.l" */
{
			print_token( "closing double quote", NULL, "<DQ_STRING>" );
			if (nidrtext[--nidrleng] == '\n')
				unput('\n');
			nidrtext[nidrleng] = 0;
			print_token( "quoted string", (char*) nidrtext, "<DQ_STRING>" );
			nidrlval.qstring = nidr_KWscopy(nidrtext);
			BEGIN DATA;
			return QUOTED_STRING;
			}
	YY_BREAK
case 23:
YY_RULE_SETUP
/* #line 253 "nidrscan.l" */
{
			print_token( "newline", NULL, NULL );
			if (nidr_comment)
				nidr_comment(nidrtext);
			nidrLineNumber++;
			}
	YY_BREAK
case 24:
YY_RULE_SETUP
/* #line 259 "nidrscan.l" */
{
			if (nidr_comment)
				nidr_comment(nidrtext);
			print_token( "comment - escaped newline", (char*) nidrtext, "<INITIAL>" );
			unput( '\\' );
			}
	YY_BREAK
case 25:
YY_RULE_SETUP
/* #line 265 "nidrscan.l" */
{
			if (nidr_comment)
				nidr_comment(nidrtext);
			print_token( "comment", (char*) nidrtext, "<INITIAL>" );
			}
	YY_BREAK
case 26:
YY_RULE_SETUP
/* #line 270 "nidrscan.l" */
{ return nidrtext[0]; }
	YY_BREAK
case 27:
YY_RULE_SETUP
/* #line 272 "nidrscan.l" */
ECHO;
	YY_BREAK
/* #line 1074 "nidr-scanner.c" */
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(DATA):
case YY_STATE_EOF(DQ_STRING):
case YY_STATE_EOF(Q_STRING):
	nidrterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int nidr_amount_of_matched_text = (int) (nidr_cp - nidrtext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*nidr_cp = nidr_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( nidr_current_buffer->nidr_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed nidrin at a new source and called
			 * nidrlex().  If so, then we have to assure
			 * consistency between nidr_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			nidr_n_chars = nidr_current_buffer->nidr_n_chars;
			nidr_current_buffer->nidr_input_file = nidrin;
			nidr_current_buffer->nidr_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for nidr_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since nidr_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( nidr_c_buf_p <= &nidr_current_buffer->nidr_ch_buf[nidr_n_chars] )
			{ /* This was really a NUL. */
			nidr_state_type nidr_next_state;

			nidr_c_buf_p = nidrtext_ptr + nidr_amount_of_matched_text;

			nidr_current_state = nidr_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * nidr_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			nidr_next_state = nidr_try_NUL_trans( nidr_current_state );

			nidr_bp = nidrtext_ptr + YY_MORE_ADJ;

			if ( nidr_next_state )
				{
				/* Consume the NUL. */
				nidr_cp = ++nidr_c_buf_p;
				nidr_current_state = nidr_next_state;
				goto nidr_match;
				}

			else
				{
				nidr_cp = nidr_c_buf_p;
				goto nidr_find_action;
				}
			}

		else switch ( nidr_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				nidr_did_buffer_switch_on_eof = 0;

				if ( nidrwrap() )
					{
					/* Note: because we've taken care in
					 * nidr_get_next_buffer() to have set up
					 * nidrtext, we can now set up
					 * nidr_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					nidr_c_buf_p = nidrtext_ptr + YY_MORE_ADJ;

					nidr_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! nidr_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				nidr_c_buf_p =
					nidrtext_ptr + nidr_amount_of_matched_text;

				nidr_current_state = nidr_get_previous_state();

				nidr_cp = nidr_c_buf_p;
				nidr_bp = nidrtext_ptr + YY_MORE_ADJ;
				goto nidr_match;

			case EOB_ACT_LAST_MATCH:
				nidr_c_buf_p =
				&nidr_current_buffer->nidr_ch_buf[nidr_n_chars];

				nidr_current_state = nidr_get_previous_state();

				nidr_cp = nidr_c_buf_p;
				nidr_bp = nidrtext_ptr + YY_MORE_ADJ;
				goto nidr_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of nidrlex */


/* nidr_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int nidr_get_next_buffer()
	{
	register char *dest = nidr_current_buffer->nidr_ch_buf;
	register char *source = nidrtext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( nidr_c_buf_p > &nidr_current_buffer->nidr_ch_buf[nidr_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( nidr_current_buffer->nidr_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( nidr_c_buf_p - nidrtext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (nidr_c_buf_p - nidrtext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( nidr_current_buffer->nidr_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		nidr_current_buffer->nidr_n_chars = nidr_n_chars = 0;

	else
		{
		int num_to_read =
			nidr_current_buffer->nidr_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = nidr_current_buffer;

			int nidr_c_buf_p_offset =
				(int) (nidr_c_buf_p - b->nidr_ch_buf);

			if ( b->nidr_is_our_buffer )
				{
				int new_size = b->nidr_buf_size * 2;

				if ( new_size <= 0 )
					b->nidr_buf_size += b->nidr_buf_size / 8;
				else
					b->nidr_buf_size *= 2;

				b->nidr_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					nidr_flex_realloc( (void *) b->nidr_ch_buf,
							 b->nidr_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->nidr_ch_buf = 0;

			if ( ! b->nidr_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			nidr_c_buf_p = &b->nidr_ch_buf[nidr_c_buf_p_offset];

			num_to_read = nidr_current_buffer->nidr_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&nidr_current_buffer->nidr_ch_buf[number_to_move]),
			nidr_n_chars, num_to_read );

		nidr_current_buffer->nidr_n_chars = nidr_n_chars;
		}

	if ( nidr_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			nidrrestart( nidrin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			nidr_current_buffer->nidr_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	nidr_n_chars += number_to_move;
	nidr_current_buffer->nidr_ch_buf[nidr_n_chars] = YY_END_OF_BUFFER_CHAR;
	nidr_current_buffer->nidr_ch_buf[nidr_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	nidrtext_ptr = &nidr_current_buffer->nidr_ch_buf[0];

	return ret_val;
	}


/* nidr_get_previous_state - get the state just before the EOB char was reached */

static nidr_state_type nidr_get_previous_state()
	{
	register nidr_state_type nidr_current_state;
	register char *nidr_cp;

	nidr_current_state = nidr_start;

	for ( nidr_cp = nidrtext_ptr + YY_MORE_ADJ; nidr_cp < nidr_c_buf_p; ++nidr_cp )
		{
		register YY_CHAR nidr_c = (*nidr_cp ? nidr_ec[YY_SC_TO_UI(*nidr_cp)] : 1);
		if ( nidr_accept[nidr_current_state] )
			{
			nidr_last_accepting_state = nidr_current_state;
			nidr_last_accepting_cpos = nidr_cp;
			}
		while ( nidr_chk[nidr_base[nidr_current_state] + nidr_c] != nidr_current_state )
			{
			nidr_current_state = (int) nidr_def[nidr_current_state];
			if ( nidr_current_state >= 125 )
				nidr_c = nidr_meta[(unsigned int) nidr_c];
			}
		nidr_current_state = nidr_nxt[nidr_base[nidr_current_state] + (unsigned int) nidr_c];
		}

	return nidr_current_state;
	}


/* nidr_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = nidr_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static nidr_state_type nidr_try_NUL_trans( nidr_state_type nidr_current_state )
#else
static nidr_state_type nidr_try_NUL_trans( nidr_current_state )
nidr_state_type nidr_current_state;
#endif
	{
	register int nidr_is_jam;
	register char *nidr_cp = nidr_c_buf_p;

	register YY_CHAR nidr_c = 1;
	if ( nidr_accept[nidr_current_state] )
		{
		nidr_last_accepting_state = nidr_current_state;
		nidr_last_accepting_cpos = nidr_cp;
		}
	while ( nidr_chk[nidr_base[nidr_current_state] + nidr_c] != nidr_current_state )
		{
		nidr_current_state = (int) nidr_def[nidr_current_state];
		if ( nidr_current_state >= 125 )
			nidr_c = nidr_meta[(unsigned int) nidr_c];
		}
	nidr_current_state = nidr_nxt[nidr_base[nidr_current_state] + (unsigned int) nidr_c];
	nidr_is_jam = (nidr_current_state == 124);

	return nidr_is_jam ? 0 : nidr_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void nidrunput( int c, register char *nidr_bp )
#else
static void nidrunput( c, nidr_bp )
int c;
register char *nidr_bp;
#endif
	{
	register char *nidr_cp = nidr_c_buf_p;

	/* undo effects of setting up nidrtext */
	*nidr_cp = nidr_hold_char;

	if ( nidr_cp < nidr_current_buffer->nidr_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = nidr_n_chars + 2;
		register char *dest = &nidr_current_buffer->nidr_ch_buf[
					nidr_current_buffer->nidr_buf_size + 2];
		register char *source =
				&nidr_current_buffer->nidr_ch_buf[number_to_move];

		while ( source > nidr_current_buffer->nidr_ch_buf )
			*--dest = *--source;

		nidr_cp += (int) (dest - source);
		nidr_bp += (int) (dest - source);
		nidr_current_buffer->nidr_n_chars =
			nidr_n_chars = nidr_current_buffer->nidr_buf_size;

		if ( nidr_cp < nidr_current_buffer->nidr_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--nidr_cp = (char) c;


	nidrtext_ptr = nidr_bp;
	nidr_hold_char = *nidr_cp;
	nidr_c_buf_p = nidr_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int nidrinput()
#else
static int input()
#endif
	{
	int c;

	*nidr_c_buf_p = nidr_hold_char;

	if ( *nidr_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* nidr_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( nidr_c_buf_p < &nidr_current_buffer->nidr_ch_buf[nidr_n_chars] )
			/* This was really a NUL. */
			*nidr_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = nidr_c_buf_p - nidrtext_ptr;
			++nidr_c_buf_p;

			switch ( nidr_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because nidr_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					nidrrestart( nidrin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( nidrwrap() )
						return EOF;

					if ( ! nidr_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return nidrinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					nidr_c_buf_p = nidrtext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) nidr_c_buf_p;	/* cast for 8-bit char's */
	*nidr_c_buf_p = '\0';	/* preserve nidrtext */
	nidr_hold_char = *++nidr_c_buf_p;


	return c;
	}
#endif /* YY_NO_INPUT */

#ifdef YY_USE_PROTOS
void nidrrestart( FILE *input_file )
#else
void nidrrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! nidr_current_buffer )
		nidr_current_buffer = nidr_create_buffer( nidrin, YY_BUF_SIZE );

	nidr_init_buffer( nidr_current_buffer, input_file );
	nidr_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void nidr_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void nidr_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( nidr_current_buffer == new_buffer )
		return;

	if ( nidr_current_buffer )
		{
		/* Flush out information for old buffer. */
		*nidr_c_buf_p = nidr_hold_char;
		nidr_current_buffer->nidr_buf_pos = nidr_c_buf_p;
		nidr_current_buffer->nidr_n_chars = nidr_n_chars;
		}

	nidr_current_buffer = new_buffer;
	nidr_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (nidrwrap()) processing, but the only time this flag
	 * is looked at is after nidrwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	nidr_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void nidr_load_buffer_state( void )
#else
void nidr_load_buffer_state()
#endif
	{
	nidr_n_chars = nidr_current_buffer->nidr_n_chars;
	nidrtext_ptr = nidr_c_buf_p = nidr_current_buffer->nidr_buf_pos;
	nidrin = nidr_current_buffer->nidr_input_file;
	nidr_hold_char = *nidr_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE nidr_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE nidr_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) nidr_flex_alloc( sizeof( struct nidr_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in nidr_create_buffer()" );

	b->nidr_buf_size = size;

	/* nidr_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->nidr_ch_buf = (char *) nidr_flex_alloc( b->nidr_buf_size + 2 );
	if ( ! b->nidr_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in nidr_create_buffer()" );

	b->nidr_is_our_buffer = 1;

	nidr_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void nidr_delete_buffer( YY_BUFFER_STATE b )
#else
void nidr_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == nidr_current_buffer )
		nidr_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->nidr_is_our_buffer )
		nidr_flex_free( (void *) b->nidr_ch_buf );

	nidr_flex_free( (void *) b );
	}

/* Fix for C99 */
#ifndef __cplusplus
extern int isatty(int);
#endif /* __cplusplus */

#ifdef YY_USE_PROTOS
void nidr_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void nidr_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	nidr_flush_buffer( b );

	b->nidr_input_file = file;
	b->nidr_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->nidr_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->nidr_is_interactive = 0;
#else
	b->nidr_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void nidr_flush_buffer( YY_BUFFER_STATE b )
#else
void nidr_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->nidr_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->nidr_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->nidr_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->nidr_buf_pos = &b->nidr_ch_buf[0];

	b->nidr_at_bol = 1;
	b->nidr_buffer_status = YY_BUFFER_NEW;

	if ( b == nidr_current_buffer )
		nidr_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE nidr_scan_buffer( char *base, nidr_size_t size )
#else
YY_BUFFER_STATE nidr_scan_buffer( base, size )
char *base;
nidr_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) nidr_flex_alloc( sizeof( struct nidr_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in nidr_scan_buffer()" );

	b->nidr_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->nidr_buf_pos = b->nidr_ch_buf = base;
	b->nidr_is_our_buffer = 0;
	b->nidr_input_file = 0;
	b->nidr_n_chars = b->nidr_buf_size;
	b->nidr_is_interactive = 0;
	b->nidr_at_bol = 1;
	b->nidr_fill_buffer = 0;
	b->nidr_buffer_status = YY_BUFFER_NEW;

	nidr_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE nidr_scan_string( nidrconst char *nidr_str )
#else
YY_BUFFER_STATE nidr_scan_string( nidr_str )
nidrconst char *nidr_str;
#endif
	{
	int len;
	for ( len = 0; nidr_str[len]; ++len )
		;

	return nidr_scan_bytes( nidr_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE nidr_scan_bytes( nidrconst char *bytes, int len )
#else
YY_BUFFER_STATE nidr_scan_bytes( bytes, len )
nidrconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	nidr_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) nidr_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in nidr_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = nidr_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in nidr_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->nidr_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void nidr_push_state( int new_state )
#else
static void nidr_push_state( new_state )
int new_state;
#endif
	{
	if ( nidr_start_stack_ptr >= nidr_start_stack_depth )
		{
		nidr_size_t new_size;

		nidr_start_stack_depth += YY_START_STACK_INCR;
		new_size = nidr_start_stack_depth * sizeof( int );

		if ( ! nidr_start_stack )
			nidr_start_stack = (int *) nidr_flex_alloc( new_size );

		else
			nidr_start_stack = (int *) nidr_flex_realloc(
					(void *) nidr_start_stack, new_size );

		if ( ! nidr_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	nidr_start_stack[nidr_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void nidr_pop_state()
	{
	if ( --nidr_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(nidr_start_stack[nidr_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int nidr_top_state()
	{
	return nidr_start_stack[nidr_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void nidr_fatal_error( nidrconst char msg[] )
#else
static void nidr_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine nidrless() so it works in section 3 code. */

#undef nidrless
#define nidrless(n) \
	do \
		{ \
		/* Undo effects of setting up nidrtext. */ \
		nidrtext[nidrleng] = nidr_hold_char; \
		nidr_c_buf_p = nidrtext + n; \
		nidr_hold_char = *nidr_c_buf_p; \
		*nidr_c_buf_p = '\0'; \
		nidrleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef nidrtext_ptr
#ifdef YY_USE_PROTOS
static void nidr_flex_strncpy( char *s1, nidrconst char *s2, int n )
#else
static void nidr_flex_strncpy( s1, s2, n )
char *s1;
nidrconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int nidr_flex_strlen( nidrconst char *s )
#else
static int nidr_flex_strlen( s )
nidrconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *nidr_flex_alloc( nidr_size_t size )
#else
static void *nidr_flex_alloc( size )
nidr_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *nidr_flex_realloc( void *ptr, nidr_size_t size )
#else
static void *nidr_flex_realloc( ptr, size )
void *ptr;
nidr_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void nidr_flex_free( void *ptr )
#else
static void nidr_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	nidrlex();
	return 0;
	}
#endif
/* #line 272 "nidrscan.l" */


 static int nidr_ateof = 0;
 static const char *nidr_instring = 0;

 void
bad_number(const char *s)
{
	fprintf(stderr, "\n*** Invalid number \"%s\" on input line %d within "
			"%s keyword.\n", s, nidrLineNumber, nidr_keyword_name());
	nidr_abort();
	}

 void
nidr_set_input_string(const char *s)
{
	nidr_instring = s;
	}

 static int
my_nidr_input(char *buf, int bmax)
{
	int c, n;

	if (nidr_ateof)
		return 0;
	n = 0;
	if (nidr_instring) {
		while(n < bmax && (c = *nidr_instring)) {
			++nidr_instring;
			if (c != '\r')
				buf[n++] = c;
			if (c == '\n')
				break;
			}
		}
	else if (nidr_current_buffer->nidr_is_interactive)
		while(n < bmax) {
		if ((c = getc(nidrin)) == EOF)
			break;
		if (c != '\r')
			buf[n++] = c;
		if (c == '\n')
			break;
		}
	else
		while(n < bmax) {
		if ((c = getc(nidrin)) == EOF)
			break;
		if (c != '\r')
			buf[n++] = c;
		}
	if (n <= 0) {
		nidr_ateof = n = 1;
		if (c == EOF) {
			fclose(nidrin);
			nidrin = NULL;
			}
		buf[0] = ';';
		}
	return n;
	}

 void
reset_nidrlex_state(void)
{
	BEGIN INITIAL;
	nidr_abort();
	}

 void
unput_string(char *s, int len)
{
	while(--len >= 0)
		unput(s[len]);
	}

 void
nidr_reinit(void)
{
	nidr_init = 1;
	nidr_ateof = 0;
	if (nidr_current_buffer) {
		free(nidr_current_buffer->nidr_ch_buf);
		free(nidr_current_buffer);
		nidr_current_buffer = 0;
		}
	}

 int
nidrwrap(void)
{ return 1; }
