#move this stuff elsewhere
from helpers import *

from dakota_in_write import *
from dakota_in_params import *
from MatlabFuncs import *


def dakota_in_data(dmeth, variables, responses, dparams, filei, *args):
    '''
    DAKOTA_IN_DATA - define the data to write the dakota .in and .m files.
    
    Usage:
        [] = dakota_in_data(dmeth, variables, responses, dparams, filei, *args)

    where the required input is:
        dmeth         (dakota_method, method class object)
        variables     (structure array, variable class objects)
        responses     (structure array, response class objects)
        dparams       (structure array, method - independent parameters)
        filei         (character, name of .in and .m files)

    Params may be empty, in which case defaults will be used.

    The optional args are passed directly through to the QmuUpdateFunctions 
    brancher to be used by the analysis package. For example, this could be 
    model information.

    This function defines the data to write the dakota .in and .m files. It is 
    necessary for multiple reasons. First, it collects the parameters and 
    applies some defaults that are unique to the environment. Second, some 
    analysis package ariables and/or responses may be treated differently by
    Dakota. For example, an analysis package variable may be defined as an 
    array, so the QmuSetupDesign brancher will create Dakota variables for each 
    element of the array. Finally, it calls the functions to write the .in and 
    .m files. this function is independent of the particular analysis package.

    This data would typically be generated by a MATLAB script for a specific 
    model, using the method, variable, and response class objects.
    '''

    #  parameters
    #  get default set of parameters
    params = dakota_in_params(struct())
    #  merge specified parameters into default set, whether or not
    #  they already exist
    fnames = fieldnames(dparams)

    for fieldname in fnames:
        if not isfield(params, fieldname):
            print('WARNING: dakota_in_data:unknown_param: No parameter {} in default parameter set.'.format(str(fieldname)))
        exec('params.{} = vars(dparams)[fieldname]'.format(fieldname))

    # use matlab even though we are running python
    if params.direct and params.analysis_driver == '':
        params.analysis_driver = 'matlab'

    if strcmpi(params.analysis_driver, 'matlab') and params.analysis_components == '':
        pathstr, name, ext = fileparts(filei)
        params.analysis_components = fullfile(pathstr, name + '.py')

    #  merge method parameters, though they shouldn't be in dparams
    # dmeth = dmeth_params_merge(dmeth, dparams)

    #  variables
    fnames = fieldnames(variables)

    # works like matlab arbitrary structs / classes, remembers order of input attributes
    dvar = OrderedStruct()
    dresp = OrderedStruct()

    for i in range(len(fnames)):
        # currently all variable types can just be copied
        exec(('dvar.%s = vars(variables)[fnames[i]]') % (fnames[i]))

    #  responses
    fnames = fieldnames(responses)

    for i in range(len(fnames)):
        #  currently all response types can just be copied
        exec(('dresp.%s = vars(responses)[fnames[i]]') % (fnames[i]))

    #  write files
    #Write in file
    dakota_in_write(dmeth, dvar, dresp, params, filei, *args)
