import numpy as np
from fielddisplay import fielddisplay
from checkfield import checkfield
from WriteData import WriteData
import MatlabFuncs as m


class groundingline(object):
    """
    GROUNDINGLINE class definition

       Usage:
          groundingline = groundingline()
    """

    def __init__(self):  # {{{
        self.migration = ''
        self.friction_interpolation = ''
        self.melt_interpolation = ''

    #set defaults
        self.setdefaultparameters()

    #}}}

    def __repr__(self):  # {{{
        string = '   grounding line migration parameters:'

        string = "%s\n%s" % (string, fielddisplay(self, 'migration', 'type of grounding line migration: ''SoftMigration'', ''SubelementMigration'', ''AggressiveMigration'', ''Contact'', ''None'''))
        string = "%s\n%s" % (string, fielddisplay(self, 'migration', 'type of friction interpolation on partially floating elements: ''SubelementFriction1'', ''SubelementFriction2'', ''NoFrictionOnPartiallyFloating'''))
        string = "%s\n%s" % (string, fielddisplay(self, 'migration', 'type of melt interpolation on partially floating elements: ''SubelementMelt1'', ''SubelementMelt2'', ''NoMeltOnPartiallyFloating'', ''FullMeltOnPartiallyFloating'''))
        return string
    #}}}

    def setdefaultparameters(self):  # {{{

        #Type of migration
        self.migration = 'SubelementMigration'
        self.friction_interpolation = 'SubelementFriction1'
        self.melt_interpolation = 'NoMeltOnPartiallyFloating'

        return self
    #}}}

    def checkconsistency(self, md, solution, analyses):  # {{{

        md = checkfield(md, 'fieldname', 'groundingline.migration', 'values', ['None', 'SubelementMigration', 'AggressiveMigration', 'SoftMigration', 'Contact', 'GroundingOnly'])
        md = checkfield(md, 'fieldname', 'groundingline.friction_interpolation', 'values', ['SubelementFriction1', 'SubelementFriction2', 'NoFrictionOnPartiallyFloating'])
        md = checkfield(md, 'fieldname', 'groundingline.melt_interpolation', 'values', ['SubelementMelt1', 'SubelementMelt2', 'NoMeltOnPartiallyFloating', 'FullMeltOnPartiallyFloating'])

        if(not m.strcmp(self.migration, 'None') and md.transient.isgroundingline and solution == 'TransientSolution'):
            if np.any(np.isnan(md.geometry.bed)):
                md.checkmessage("requesting grounding line migration, but bathymetry is absent!")
            pos = np.nonzero(md.mask.ocean_levelset > 0.)[0]
            if any(np.abs(md.geometry.base[pos] - md.geometry.bed[pos]) > 10**-10):
                md.checkmessage("base not equal to bed on grounded ice!")
            if any(md.geometry.bed - md.geometry.base > 10**-9):
                md.checkmessage("bed superior to base on floating ice!")

        return md
    # }}}

    def marshall(self, prefix, md, fid):  # {{{
        WriteData(fid, prefix, 'data', self.migration, 'name', 'md.groundingline.migration', 'format', 'String')
        WriteData(fid, prefix, 'data', self.friction_interpolation, 'name', 'md.groundingline.friction_interpolation', 'format', 'String')
        WriteData(fid, prefix, 'data', self.melt_interpolation, 'name', 'md.groundingline.melt_interpolation', 'format', 'String')
    # }}}
