#!/bin/bash
set -eu


# Clean up
rm -rf install

# Download development version
git clone git://sourceware.org/git/valgrind.git install

# Configure
cd install
./autogen.sh
./configure \
	--prefix="$ISSM_DIR/externalpackages/valgrind/install" \
	--enable-only64bit

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make install -j $1
fi
