function data_out=InterpFromFile(x,y,filename,default_value)
%INTERPFROMFILE - load data and interpolate on the given nodes
%
%   load a matlab file (extension .mat) which holds 3 or 4 variables
%   and interpolate the data on the mesh and plug it onto the model.
%
%   o 3 variables
%     - a vector x (if the name of the variable do not begin with "x", an error can appear)
%     - a vector y (if the name of the variable do not begin with "y", an error can appear)
%     - a vector or matrix data (if the name of the variable do not begin with the field name, an error can appear)
%   o 4 variables
%     - a vector x (if the name of the variable do not begin with "x", an error can appear)
%     - a vector y (if the name of the variable do not begin with "y", an error can appear)
%     - a matrix with 3 columns (if the name of the variable do not begin with "index" or "elements", an error can appear)
%     - a vector data (if the name of the variable do not begin with the field name, an error can appear)
%
%   Usage:
%      data=InterpFromFile(x,y,filename,default_value);
%
%   Example:
%      md.surface=InterpFromFile(md.x,md.y,'surfacefile.mat',0);
%
%   See also: PLUGVELOCITIES, INTERPFROMGRID, INTERPFROMMESH2D, INTERPFROMMESH3D

%some checks
if nargin~=4 | nargout~=1
	help InterpFromFile
	error('plugdata error message: bad usage');
end
if ~exist(filename)
	error(['plugdata error message: file ' filename  ' does not exist']);
end
if length(x)~=length(y),
	error('plugdata error message: x and y should have the same length');
end

%load file
Names=FieldFindVarNames(filename);
Data=load(filename);
if strcmpi(Names.interp,'grid'),
	data_out=InterpFromGridToMesh(Data.(Names.xname),Data.(Names.yname),Data.(Names.dataname),x,y,default_value);
else
	data_out=InterpFromMeshToMesh2d(Data.(Names.indexname),Data.(Names.xname),Data.(Names.yname),Data.(Names.dataname),x,y,default_value);
end
