function md=plugvelocities(md,filename,default_value)
%PLUGVELOCITIES - load velocities on a model
%
%   load a matlab file (extension .mat) which holds 4 variables
%   x,y,vx,vy to be plugged onto the model (or similar names)
%   x and y must be vectors, vx, vy matrices
%
%   Usage:
%      md=plugvelocities(md,filename,default_value)
%
%   Example:
%      md=plugvelocities(md,'velocityfile.mat',0);
%
%   See also: INTERPFROMFILE, GRIDDATA

%some checks
if nargin~=3 | nargout~=1
	help plugvelocities
	error('plugvelocities error message: bad usage');
end
if ~exist(filename)
	error(['plugvelocities error message: file ' filename  ' does not exist']);
end

%load velocities 
Names=VelFindVarNames(filename);
Vel=load(filename);

%Interpolation
if strcmpi(Names.interp,'grid'),
	md.vx_obs=InterpFromGridToMesh(Vel.(Names.xname),Vel.(Names.yname),Vel.(Names.vxname),md.x,md.y,default_value);
	md.vy_obs=InterpFromGridToMesh(Vel.(Names.xname),Vel.(Names.yname),Vel.(Names.vyname),md.x,md.y,default_value);
else
	md.vx_obs=InterpFromMeshToMesh2d(Vel.(Names.indexname),Vel.(Names.xname),Vel.(Names.yname),Vel.(Names.vxname),md.x,md.y,default_value);
	md.vy_obs=InterpFromMeshToMesh2d(Vel.(Names.indexname),Vel.(Names.xname),Vel.(Names.yname),Vel.(Names.vyname),md.x,md.y,default_value);
end

md.vel_obs=sqrt(md.vx_obs.^2+md.vy_obs.^2);
md.vx=md.vx_obs;
md.vy=md.vy_obs;
md.vel=md.vel_obs;
