%SOLIDEARTHSOLUTION class definition
%
%   Usage:
%      solidearthsolution=solidearthsolution();

classdef solidearthsolution
	properties (SetAccess=public) 
		displacementeast = [];
		displacementnorth =[];
		displacementup=[];
		geoid=[];
		barystaticsealevel=[];
	end
	methods
		function self = solidearthsolution(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = setdefaultparameters(self) % {{{
	
			self.displacementeast = [];
			self.displacementnorth =[];
			self.displacementup=[];
			self.geoid=[];
			self.barystaticsealevel=[];
	
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			if ~ismember('SealevelriseAnalysis',analyses) | (strcmp(solution,'TransientSolution') & md.transient.isslr==0), 
				return; 
			end
			md = checkfield(md,'fieldname','solidearth.solution.displacementeast','Inf',1,'timeseries',1);
			md = checkfield(md,'fieldname','solidearth.solution.displacementnorth','Inf',1,'timeseries',1);
			md = checkfield(md,'fieldname','solidearth.solution.displacementup','Inf',1,'timeseries',1);
			md = checkfield(md,'fieldname','solidearth.solution.geoid','Inf',1,'timeseries',1);
			md = checkfield(md,'fieldname','solidearth.solution.barystaticsealevel','Inf',1,'timeseries',1);

		end % }}}
		function disp(self) % {{{
			disp(sprintf('   solidearth solution:'));

			fielddisplay(self,'displacementeast','solid-Earth Eastwards bedrock motion (m/yr)');
			fielddisplay(self,'displacementnorth','solid-Earth Northwards bedrock motion (m/yr)');
			fielddisplay(self,'displacementup','solid-Earth bedrock uplift rate (m/yr)');
			fielddisplay(self,'geoid','solid-Earth geoid motion (m/yr)');
			fielddisplay(self,'barystaticsealevel','barystatic absolute sea-level rate (m/yr)');

		end % }}}
		function marshall(self,prefix,md,fid) % {{{
			WriteData(fid,prefix,'object',self,'data',1,'name','md.solidearth.external.nature','format','Integer'); %code 1 for father class
			yts=md.constants.yts;
			WriteData(fid,prefix,'object',self,'class','solidearthsolution','fieldname','displacementeast','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
			WriteData(fid,prefix,'object',self,'class','solidearthsolution','fieldname','displacementnorth','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
			WriteData(fid,prefix,'object',self,'class','solidearthsolution','fieldname','displacementup','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
			WriteData(fid,prefix,'object',self,'class','solidearthsolution','fieldname','geoid','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
			WriteData(fid,prefix,'object',self,'class','solidearthsolution','fieldname','barystaticsealevel','format','DoubleMat','mattype',1,'scale',1./yts,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
	
		end % }}}
		function savemodeljs(self,fid,modelname) % {{{
			writejs1Darray(fid,[modelname '.solidearth.external.displacementeast'],self.displacementeast);
			writejs1Darray(fid,[modelname '.solidearth.external.displacementnorth'],self.displacementnorth);
			writejs1Darray(fid,[modelname '.solidearth.external.displacementup'],self.displacementup);
			writejs1Darray(fid,[modelname '.solidearth.external.geoid'],self.geoid);
			writejs1Darray(fid,[modelname '.solidearth.external.barystaticsealevel'],self.barystaticsealevel);
		end % }}}
		function self = extrude(self,md) % {{{
		end % }}}
	end
end
