#!/bin/bash
set -eu


# TODO:
# - Add support for,
#	- BLAS_LAPACK
#	- MUMPS
#	- PETSC
# (see configs/4/mac/static/CMakeLists.txt)
#

## Constants
#
VER="4.5.6"

PETSC_ROOT="${ISSM_DIR}/externalpackages/petsc/install"

# Cleanup
rm -rf install src
mkdir install src

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/gmsh-${VER}-source.tgz" "gmsh-${VER}-source.tgz"

# Untar source
tar -xvzf gmsh-${VER}-source.tgz

# Move source to 'src' directory
mv gmsh-${VER}-source/* src
rm -rf gmsh-${VER}-source

# Copy customized source and config files to 'src' directory
cp configs/${VER}/mac/static/CMakeLists.txt src

# Configure
#
# NOTE:
# - Option -DENABLE_FLTK=0 is used because we do not need GUI.
# - Option -DENABLE_MPEG_ENCODE=0 is used because we do not need to record MPEG 
#	movies.
# - Option -DENABLE_OCC=0 is used because we do not need CAD kernel and are not 
#	importing STEP/IGES files.
# - Option -DENABLE_TOUCHBAR=0 is used because we do not have GUI, therefore we 
#	do not need to support Apple Touch bar.
#
cd install
cmake ../src \
	-DCMAKE_INSTALL_PREFIX="${ISSM_DIR}/externalpackages/gmsh/install" \
	-DENABLE_BUILD_LIB=1 \
	-DENABLE_FLTK=0 \
	-DENABLE_MPEG_ENCODE=0 \
	-DENABLE_MPI=1 \
	-DENABLE_OCC=0 \
	-DENABLE_TOUCHBAR=0 \
	-DMETIS_ROOT="${PETSC_ROOT}"

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
