from fielddisplay import fielddisplay


class results(object): #{{{
    """RESULTS class definition

    Usage:
        md.results = results()
    """

    def __init__(self, *args): #{{{
        pass
    #}}}

    def __repr__(self): #{{{
        s = ''
        if 'step' in self.__dict__:
            s += '{}\n'.format(fielddisplay(self, 'step', "step number"))
        if 'time' in self.__dict__:
            s += '{}\n'.format(fielddisplay(self, 'time', "time value"))
        if 'SolutionType' in self.__dict__:
            s += '{}\n'.format(fielddisplay(self, 'SolutionType', "solution type"))

        for name in list(self.__dict__.keys()):
            if name not in ['step', 'time', 'SolutionType', 'errlog', 'outlog']:
                if isinstance(getattr(self, name), list):
                    s += '{}\n'.format(fielddisplay(self, name, "model results list"))
                elif isinstance(getattr(self, name), results):
                    s += '{}\n'.format(fielddisplay(self, name, "model results case"))
                else:
                    s += '{}\n'.format(fielddisplay(self, name, ""))

        if 'errlog' in self.__dict__:
            s += '{}\n'.format(fielddisplay(self, 'errlog', "error log file"))
        if 'outlog' in self.__dict__:
            s += '{}\n'.format(fielddisplay(self, 'outlog', "output log file"))

        return s
    #}}}

    def setdefaultparameters(self): #{{{
        #do nothing
        return self
    #}}}

    def checkconsistency(self, md, solution, analyses): #{{{
        return md
    #}}}

    def marshall(self, prefix, md, fid): #{{{
        pass
    #}}}
#}}}

class resultselement(object): #{{{
    """RESULTSELEMENT class definition - Value of attribute of results

    Usage:
        setattr(md.results, '<solution_type>', resultselement())
    """

    def __init__(self, *args): #{{{
        self.elements = [result()]
    #}}}

    def __repr__(self): #{{{
        s = '  1x{} struct array with fields:\n'.format(len(self.elements))
        s += '\n'

        if len(self.elements) >= 1:
            for name in list(self.elements[0].__dict__.keys()):
                s += '    {}\n'.format(name)

        return s
    #}}}

    def __len__(self): #{{{
        return len(self.elements)
    #}}}

    def __getitem__(self, index): #{{{
        while True:
            try:
                return self.elements[index]
            except:
                self.elements.append(result())
    #}}}

    def __setitem__(self, index, value): #{{{
        while True:
            try:
                self.elements[index] = value
                break
            except:
                self.elements.append(result())
    #}}}

    def setdefaultparameters(self): #{{{
        return self
    #}}}

    def checkconsistency(self, md, solution, analyses): #{{{
        return md
    #}}}

    def marshall(self, prefix, md, fid): #{{{
        pass
    #}}}
#}}}

class result(object): #{{{
    """RESULT class definition - Element of resultselement::elements

    Usage:
        resultselement.elements.append(result())
    """

    def __init__(self, *args): #{{{
        pass
    #}}}

    def setdefaultparameters(self): #{{{
        return self
    #}}}

    def checkconsistency(self, md, solution, analyses): #{{{
        return md
    #}}}

    def marshall(self, prefix, md, fid): #{{{
        pass
    #}}}
#}}}
