/*!\file: groundingline_core.cpp
 * \brief: core of the groundingline solution
 */

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void groundingline_core(FemModel* femmodel){

	/*Start profiler*/
	femmodel->profiler->Start(GROUNDINGLINECORE);

	/* intermediaries */
	bool save_results;

	/* recover parameters */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	/*Move grounding line*/
	if(VerboseSolution()) _printf0_("   computing new grounding line position\n");
	GroundinglineMigrationx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);

	/*Update geometry and mask accordingly*/
	femmodel->parameters->SetParam(MaskOceanLevelsetEnum,InputToExtrudeEnum);
	extrudefrombase_core(femmodel);
	femmodel->parameters->SetParam(BaseEnum,InputToExtrudeEnum);
	extrudefrombase_core(femmodel);
	femmodel->parameters->SetParam(SurfaceEnum,InputToExtrudeEnum);
	extrudefrombase_core(femmodel);

	if(save_results){
		int outputs[3] = {SurfaceEnum,BaseEnum,MaskOceanLevelsetEnum};
		femmodel->RequestedOutputsx(&femmodel->results,&outputs[0],3);
	}

	/*Stop profiler*/
	femmodel->profiler->Stop(GROUNDINGLINECORE);
}
