#!/bin/bash
set -eu

#WARNING: make sure you have the right mpi

#Some cleanup
rm -rf install petsc-3.14.0 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://ftp.mcs.anl.gov/pub/petsc/release-snapshots/petsc-lite-3.14.0.tar.gz' 'petsc-3.14.0.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.14.0.tar.gz
mv petsc-3.14.0/* src/
rm -rf petsc-3.14.0

#configure
cd src
./config/configure.py \
	COPTFLAGS="-g -O3" CXXOPTFLAGS="-g -O3" FOPTFLAGS="-g -O3" \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-blas-lapack-dir="/sopt/INTEL/compilers_and_libraries_2018.3.222/linux/mkl/" \
	--with-mpi-dir="/sopt/OpenMPI/3.1.2/intel-2018.3-slim/" \
	--known-mpi-shared-libraries=1 \
	--known-64-bit-blas-indices \
	--known-mpi-long-double=1 \
	--known-mpi-int64_t=1 \
	--known-mpi-c-double-complex=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-scalapack=1 \
	--download-mumps=1 

# Compile and install
make
make install
