function matrix=mme_time_correlation_matrix(mme,varargin); 

	if nargin==2,
		type=varargin{1};
	elseif nargin==3,
		mme2=varargin{1};
		type=varargin{2};
	else 
		error('mme_time_correlation_matrix usage error: 2 or 3 arguments only allowed!');
	end

	if nargin==2,

		%Out of a multi model ensemble (nsamples x nsteps) of runs, build 
		%a temporal correlation matrix (of size nsteps x nsteps)

		nsamples=size(mme,1);
		nsteps=size(mme,2);

		%initialize with 1 in the diagonal: 
		matrix=eye(nsteps,nsteps);

		%go through time steps, and fill up the top part. 
		for i=1:nsteps,
			for j=i+1:nsteps,
				matrix(i,j)=corr(mme(:,i),mme(:,j),'Type',type);
				matrix(j,i)=matrix(i,j);
			end
		end
	else

		%Same kind of computations, except it's not autocorrelation:
		nsamples=size(mme,1); nsamples2=size(mme2,1);
		nsteps=size(mme,2); nsteps2=size(mme2,2);

		if nsteps2~=nsteps,
			error('number of time steps from both sample matrices should be identical!');
		end
		if nsamples2~=nsamples,
			error('number of samples from both sample matrices should be identical!');
		end

		%initialize with 1 in the diagonal: 
		matrix=zeros(nsteps,nsteps);

		%go through time steps, and fill up the top part. 
		for i=1:nsteps,
			for j=i:nsteps,
				matrix(i,j)=corr(mme(:,i),mme2(:,j),'Type',type);
				matrix(j,i)=matrix(i,j);
			end
		end
	end
