step=[2];
division=2;
density=100000;
startup

%step1: initial velocity -> observed velocity
if ismember(1,step),
	disp(sprintf('\nSTEP 1 : Build observed velocity\n'));

	%create model
	md=model;
	md=mesh(md,'DomainOutline.exp',density);
	md=geography(md,'all','');
	md=parameterize(md,'Square.par');
	md=setelementstype(md,'macayeal','all');

	%tweak B
	maxx=max(md.x); minx=min(md.x); Lx=maxx-minx;
	maxy=max(md.y); miny=min(md.y); Ly=maxy-miny;
	temperature=linspace(213,263,division^2);
	temperature=temperature(randperm(division^2));
	count=1;
	for i=1:division
		for j=1:division
			md.observed_temperature(find(md.x>=(minx+(i-1)*Lx/division) & md.x<=(minx+i*Lx/division) & md.y>=(miny+(j-1)*Ly/division) & md.y<=(miny+j*Ly/division)))=temperature(count);
			md.B=paterson(md.observed_temperature);
			count=count+1;
		end
	end

	%diagnostic with this B
	md.cluster='wilkes'; 
	md=solve(md,'analysis_type','diagnostic');

	%save observed velocities and exact B
	vx_obs=md.vx; vy_obs=md.vy; vel_obs=md.vel;
	B=md.B;
	save ObservedVelocities vx_obs vy_obs vel_obs
	save ExactB B
	clear md
end

%step2: control method
if ismember(2,step),
	disp(sprintf('\nSTEP 2 : control method\n'));

	%create model
	md=model;
	md=mesh(md,'DomainOutline.exp',density);
	md=geography(md,'all','');
	md=parameterize(md,'Square.par');
	md=setelementstype(md,'macayeal','all');

	%plug computed velocities
	load ObservedVelocities
	md.vx_obs=vx_obs; md.vy_obs=vy_obs; md.vel_obs=vel_obs;

	%control method
	md.nsteps=5;
	md.control_type='B';
	md.mincontrolconstraint=10^7;
	md.maxcontrolconstraint=1.2*10^9;
	md.plot=1;
	md.debug=0;
	md.optscal=10^8*ones(md.nsteps,1); md.optscal(1)=2*10^8;
	md.fit=0*ones(md.nsteps,1);
	md.maxiter=10*ones(md.nsteps,1);
	md.eps_rel=0.0001;
	md.eps_abs=NaN;
	md.viscosity_overshoot=0;

	md.np=8;
	%md.cluster='wilkes';
	%md=solve(md,'analysis_type','control');
	md=solve(md,'analysis_type','control');
	%md=solve(md,'analysis_type','control','package','macayeal');
end
