/*!\file SetControlInputsFromVectorx
 * \brief retrieve vector from inputs in elements
 */

#include "./SetControlInputsFromVectorx.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"

void SetControlInputsFromVectorx(FemModel* femmodel,IssmDouble* vector){

	int  num_controls;
	int* control_type = NULL;
	int* M = NULL;
	int* N = NULL;

	/*Retrieve some parameters*/
	femmodel->parameters->FindParam(&num_controls,InversionNumControlParametersEnum);
	femmodel->parameters->FindParam(&control_type,NULL,InversionControlParametersEnum);
	femmodel->parameters->FindParam(&M,NULL,ControlInputSizeMEnum);
	femmodel->parameters->FindParam(&N,NULL,ControlInputSizeNEnum);

	int offset = 0;
	for(int i=0;i<num_controls;i++){
		for(Object* & object : femmodel->elements->objects){
			Element* element=xDynamicCast<Element*>(object);
			element->SetControlInputsFromVector(vector,control_type[i],i,offset,M[i],N[i]);
		}
		offset += M[i]*N[i]; 
	}

	xDelete<int>(control_type);
	xDelete<int>(M);
	xDelete<int>(N);
}

void SetControlInputsFromVectorx(FemModel* femmodel,Vector<IssmDouble>* vector){

	IssmDouble* serial_vector=vector->ToMPISerial();
	SetControlInputsFromVectorx(femmodel,serial_vector);
	xDelete<IssmDouble>(serial_vector);
}
