function J =objectivefunctionC(search_scalar,m,p_g,u_g_obs,grad_g,n);
        
%recover some parameters
optscal=m.parameters.optscal(n);
fit=m.parameters.fit(n);
control_type=m.parameters.control_type;

%Update along gradient using scalar supplied by fmincon optimization routine
parameter=p_g+search_scalar*optscal*grad_g;

%Plug parameter into inputs
inputs=parameterinputs;
inputs=add(inputs,'velocity',m.parameters.u_g,'doublevec',3,m.parameters.numberofnodes);
inputs=add(inputs,m.parameters.control_type,parameter,'doublevec',2,m.parameters.numberofnodes);

%Run diagnostic with updated parameters.
u_g=diagnostic_core_nonlinear(m,inputs);

%Compute misfit for this velocity field. 
inputs=add(inputs,'fit',m.parameters.fit(n),'double');
J=Misfit(m.elements,m.nodes,m.loads,m.materials,m.parameters, u_g, u_g_obs,inputs);
