/*!\file:  InterpFromGridToMeshx.cpp
 * \brief  "c" core code for interpolating values from a structured grid.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


#include "./InterpFromGridToMeshx.h"
#include "../shared/shared.h"

#undef __FUNCT__ 
#define __FUNCT__ "InterpFromGridToMeshx"


int InterpFromGridToMeshx( Vec* pdata_mesh,double* x_in, int x_rows, double* y_in, int y_rows, double* data, int M, int N, double* x_mesh, double* y_mesh, int nods,double default_value) {


	/*output: */
	Vec data_mesh=NULL;
	
	/*Intermediary*/
	double* x=NULL;
	double* y=NULL;
	double  x_grid,y_grid;
	int     i;

	/*threading: */
	InterpFromGridToMeshxThreadStruct gate;
	int num=1;

	#ifdef _MULTITHREADING_
	num=_NUMTHREADS_;
	#endif

	/*Some checks on arguments: */
	if ((M<=2) || (N<=2) || (nods<=0)){
		throw ErrorException(__FUNCT__,"nothing to be done according to the dimensions of input matrices and vectors.");
	}

	/*Allocate output vector: */
	data_mesh=NewVec(nods);

	/*Find out what kind of coordinates (x_in,y_in) have been given is input*/
	if(N==(x_rows-1) && M==(y_rows-1)){

		/*The coordinates given in input describe the contour of each pixel. Take the center of each pixel*/
		x=(double*)xmalloc(N*sizeof(double));
		y=(double*)xmalloc(M*sizeof(double));
		for (i=0;i<N;i++) x[i]=(x_in[i]+x_in[i+1])/2;
		for (i=0;i<M;i++) y[i]=(y_in[i]+y_in[i+1])/2;
		x_rows=x_rows-1;
		y_rows=y_rows-1;
	}
	else if (M==x_rows && N==x_rows){

		/*The coordinates given in input describe the center each pixel. Keep them*/
		x=(double*)xmalloc(N*sizeof(double));
		y=(double*)xmalloc(M*sizeof(double));
		for (i=0;i<N;i++) x[i]=x_in[i];
		for (i=0;i<M;i++) y[i]=y_in[i];
	}
	else{
		throw ErrorException(__FUNCT__,"x and y vectors length should be 1 or 0 more than data number of rows.");
	}

	/*initialize thread parameters: */
	gate.x_mesh=x_mesh;
	gate.y_mesh=y_mesh;
	gate.x_rows=x_rows;
	gate.y_rows=y_rows;
	gate.x=x;
	gate.y=y;
	gate.nods=nods;
	gate.data_mesh=data_mesh;
	gate.data=data;
	gate.M=M;
	gate.N=N;

	/*launch the thread manager with InterpFromGridToMeshxt as a core: */
	LaunchThread(InterpFromGridToMeshxt,(void*)&gate,num);

	/*Assign output pointers:*/
	*pdata_mesh=data_mesh;
}
