import numpy as np

from checkfield import checkfield
from fielddisplay import fielddisplay
from WriteData import WriteData


class surfaceload(object):
    """SURFACELOAD class definition

    Usage:
        surfaceload = surfaceload()
    """

    def __init__(self, *args): #{{{
        self.icethicknesschange = []
        self.waterheightchange  = []
        self.other              = []
        
        nargin = len(args)

        if nargin == 0:
            self.setdefaultparameters()
        else:
            raise Exception('constructor not supported')
    #}}}

    def __repr__(self): # {{{
        s = '   surfaceload:\n'
        s += '{}\n'.format(fielddisplay(self, 'icethicknesschange', 'thickness change: ice height equivalent [mIce/yr]'))
        s += '{}\n'.format(fielddisplay(self, 'waterheightchange', 'water height change: water height equivalent [mWater/yr]'))
        s += '{}\n'.format(fielddisplay(self, 'other', 'other loads (sediments) [kg/m^2/yr]'))

        return s
    #}}}

    def setdefaultparameters(self): # {{{
        return
    #}}}

    def checkconsistency(self, md, solution, analyses): # {{{
        if ('SealevelriseAnalysis' not in analyses) or (solution == 'TransientSolution' and md.transient.isslr == 0):
            return md

        if len(self.icethicknesschange):
            md  = checkfield(md,'fieldname', 'solidearth.surfaceload.icethicknesschange', 'timeseries', 1, 'NaN', 1, 'Inf', 1)

        if len(self.waterheightchange):
            md  = checkfield(md,'fieldname', 'solidearth.surfaceload.waterheightchange', 'timeseries', 1, 'NaN', 1, 'Inf', 1)

        if len(self.other):
            md  = checkfield(md,'fieldname', 'solidearth.surfaceload.other', 'timeseries', 1, 'NaN', 1, 'Inf', 1)

        return md
    #}}}

    def marshall(self, prefix, md, fid): #{{{
        if len(self.icethicknesschange) == 0:
            self.icethicknesschange = np.zeros((md.mesh.numberofelements + 1, ))

        if len(self.waterheightchange) == 0:
            self.waterheightchange = np.zeros((md.mesh.numberofelements + 1, ))

        if len(self.other) == 0:
            self.other = np.zeros((md.mesh.numberofelements + 1, ))

        WriteData(fid, prefix, 'object', self, 'fieldname', 'icethicknesschange', 'name', 'md.solidearth.surfaceload.icethicknesschange', 'format', 'DoubleMat', 'mattype', 2, 'timeserieslength', md.mesh.numberofelements + 1, 'yts', md.constants.yts)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'waterheightchange', 'name', 'md.solidearth.surfaceload.waterheightchange', 'format', 'DoubleMat', 'mattype', 2, 'timeserieslength', md.mesh.numberofelements + 1, 'yts', md.constants.yts)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'other', 'name', 'md.solidearth.surfaceload.other', 'format', 'DoubleMat', 'mattype', 2, 'timeserieslength', md.mesh.numberofelements + 1, 'yts', md.constants.yts)
    #}}}

    def extrude(self, md): #{{{
        return self
    #}}}
