function dofset=dofsetgen(doflist,numdofs,dofsize)
%DOFSETGEN - generate a dof  set to index a solution vector
%
%   Usage:
%      dofset=dofsetgen(doflist,numdofs,dofsize)
%
%   ex: 
%      dof1set=dofsetgen([1],3,10); will generate 1,4,7,10
%      dof2set=dofsetgen([2],4,10); will generate 2,6,10
%      dof12set=dofsetgen([1,2],5,15); will generate 1,2,6,7,11,12


flags=zeros(dofsize,1);

for i=1:length(doflist),
	flags(doflist(i):numdofs:end)=1;
end

dofset=find(flags);
