function pretty_print(data)
%PRETTY_PRINT - print longer structures as they would be under Python
%
%   Utility function for debugging to print large structures.
%
%   Usage:
%      pretty_print(data)
%
%   NOTE:
%   - Currently only handles 1- and 2D structures.
%
%   TODO:
%   - Add an argument that allows the user to specify what constitutes a "long" 
%   large data structure (default is length of 6).
%   - Add an argument that allows the user to specify the number of values that 
%   they would like to display from the head and tail of each dimension of 
%   'data'.

if ndims(data)==1
	if length(data)>6
		disp(sprintf('[%d %d %d ... %d %d %d]',data(1),data(2),data(3),data(end-2),data(end-1),data(end)));
	else
		disp(data);
	end
elseif ndims(data)==2
	shape=size(data);
	if shape(1)>6
		% if shape(2)==1
		% 	disp('NOTE: Single column printed as row!');
		% 	disp(sprintf('[%d %d %d ... %d %d %d]',data(1,1),data(2,1),data(3,1),data(end-2,1),data(end-1,1),data(end,1)));
		% else
		if shape(2)>6
			disp('[');
			disp(sprintf('[%d %d %d ... %d %d %d]',data(1,1),data(1,2),data(1,3),data(1,end-2),data(1,end-1),data(1,end)));
			disp(sprintf('[%d %d %d ... %d %d %d]',data(2,1),data(2,2),data(2,3),data(2,end-2),data(2,end-1),data(2,end)));
			disp(sprintf('[%d %d %d ... %d %d %d]',data(3,1),data(3,2),data(3,3),data(3,end-2),data(3,end-1),data(3,end)));
			disp('...');
			disp(sprintf('[%d %d %d ... %d %d %d]',data(end-2,1),data(end-2,2),data(end-2,3),data(end-2,end-2),data(end-2,end-1),data(end-2,end)));
			disp(sprintf('[%d %d %d ... %d %d %d]',data(end-1,1),data(end-1,2),data(end-1,3),data(end-1,end-2),data(end-1,end-1),data(end-1,end)));
			disp(sprintf('[%d %d %d ... %d %d %d]',data(end,1),data(end,2),data(end,3),data(end,end-2),data(end,end-1),data(end,end)));
			disp(sprintf(']\n'));
		else
			disp('[');
			disp(data(1,:));
			disp(data(2,:));
			disp(data(3,:));
			disp('...');
			disp(data(end-2,:));
			disp(data(end-1,:));
			disp(data(end,:));
			disp(sprintf(']\n'));
		end
	else
		% if shape(2)==1
		% 	data=transpose(data)
		% 	sprintf('% NOTE: Single column printed as row!');
		% 	% Get shape of transposed structure
		% 	shape=size(data);
		% 	if shape(2)>6
		% 		disp(sprintf('[%d %d %d ... %d %d %d]',data(1,1),data(2,1),data(3,1),data(end-2,1),data(end-1,1),data(end,1)));
		% 	else
		% 		disp(data);
		% 	end
		% else
		if shape(2)>6
			disp('[');
			for i=1:shape(1)
				disp(sprintf('[%d %d %d ... %d %d %d]',data(i,1),data(i,2),data(i,3),data(i,end-2),data(i,end-1),data(i,end)));
			end
			disp(sprintf(']\n'));
		else
			disp(data);
		end
	end
else
	disp(data);
end
