#!/bin/bash
#script version of waitonlock.m
#function flag=waitonlock(filename,timelimit)
#%WAITONLOCK - wait for a file
#%
#%   This routine will return when a file named 'filename' is written to disk.
#%   If the time limit given in input is exceeded, return 0
#%
#%   Usage:
#%      flag=waitonlock(filename,timelimit)

#Check input value
if [ $# -ne 2 ];
then
	#no config file specified: exit
	echo "waitonlock.sh error message: bad usage"
	exit 0
fi

#initialization
TIME=1;
STEP=1;  #step in seconds
FILE=$1;

#check time limit
if [ "$2" == "Inf" ]
then
	echo infinity detected
	LIMIT=999999999;
else
	echo not inf
	let LIMIT=$2*60;
fi

#display
echo "waiting for $1 hold on (ctl+c to stop)..."

#Loop till file is found
while [ $TIME -lt $LIMIT ]
do

	#lock file exists?
	if [ -e $FILE ]; then
		break;
	fi

	#No-> wait one second
	sleep $STEP
	let TIME+=1;
	echo "waiting $TIME seconds ($TIME < $LIMIT)"
	dummy=$(ls); #force bash to refresh file list

done

#Compute flag
if [ $TIME -lt $LIMIT ]; then 
	exit 1;
else
	exit 0;
fi
