function md=LaunchQueueJobgemini(md,executionpath,options)
%LAUNCHQUEUEJOBGEMINI - Launch queueing script on Gemini cluster
%
%   Usage:
%      LaunchQueueJobgemini(md,executionpath)

%first, check we have the binary file and the queueing script
if ~exist([ md.name '.bin'],'file'),
	error('LaunchQueueJobgemini error message: Binary input file missing, cannot go forward');
end

if ~exist([ md.name '.queue'],'file'),
	error('LaunchQueueJobgemini error message: queueing script issing, cannot go forward');
end

%jpload both files to cluster
if ~strcmpi(options.batch,'yes'),
	disp('uploading input file,  queueing script and variables script');
	if md.qmu_analysis, 
		eval(['!scp ' md.name '.bin' ' ' md.name '.queue '  md.name '.qmu.in ' md.cluster ':' executionpath]);
	else
		eval(['!scp ' md.name '.bin' ' ' md.name '.queue '  md.cluster ':' executionpath]);
	end
	
	disp('launching solution sequence on remote cluster');
	issmssh(md.cluster,['"cd ' executionpath ' && qsub ' md.name '.queue "']);
else
	disp('batch mode requested: not launching job interactively');

	%new gemini cannot launch across cluster using ssh
	disp(['launch solution sequence on remote cluster by logging into it and typing qsub < ' md.name '.queue']);
end
md.waitonlock=0; %cannot wait for lock
