/*!\file ConfigureObjectsx
 * \brief: configure objects in elements and loads to link in with nodes
 */

#include "./ConfigureObjectsx.h"

#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../../classes/classes.h"

int	ConfigureObjectsx( Elements* elements, Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters,Inputs* inputs){

	/*Get analysis type: */
	int configuration_type;
	parameters->FindParam(&configuration_type,ConfigurationTypeEnum);

	if(VerboseMProcessor()) _printf0_("      Configuring elements...\n");
	for(int i=0;i<elements->Size();i++){
		Element* element=xDynamicCast<Element*>(elements->GetObjectByOffset(i));
		element->Configure(elements,loads,nodes,vertices,materials,parameters,inputs);
	}
	if(VerboseMProcessor()) _printf0_("      Configuring loads...\n");
	for(int i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->Configure(elements,loads,nodes,vertices,materials,parameters);
	}
	if(VerboseMProcessor()) _printf0_("      Configuring materials...\n");
	for(int i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->Configure(elements);
	}
	if(VerboseMProcessor()) _printf0_("      Configuring inputs...\n");
	inputs->Configure(parameters);

	return 1;
}
