% MEALPix
%   alm2pix    - Evaluate spherical harmonic function expansion on HEALPix pixels
%   alm2spec   - valuate angular power spectral density
%   ang2pix    - Convert spherical coordinate location to HEALPix pixel number
%   ang2vec    - Convert from spherical to cartesian coordinates
%   angDist    - Computes angular distance on the unit sphere
%   corners    - Find pixel corners
%   hp3d       - Plots a HEALPix dataset on a 3D sphere
%   hpInterp   - Interpolate data on sphere to MEALPix pixels
%   hpStat     - Compute descriptive statistics of a pixel value list
%   inRing     - return pixels in ring or ring section
%   nPix2nSide - Convert number of pixels to number of facet side subdivisions
%   nSide2nPix - Convert resolution parameter to number of pixels
%   nSide2res  - Calculates angular resolution of a HEALPix map in arcsec 
%   nest2ring  - Convert MEALPix pixel numbers from nest to ring indexing
%   pix2alm    - Find spherical harmonic decomposition of function on sphere
%   pix2ang    - Find spherical coordinate location of HEALPix pixels
%   pix2vec    - convert HEALPix pixel numbers to (x,y,z) unit vector
%   pix2xy     - Find pixel cartesian face coordinates
%   queryDisc  - Find all pixels whose centers are within a specified disc
%   res2nSide  - Finds minimum base pixel sub-division for required resolution
%   ring2nest  - Convert MEALPix pixel numbers from ring to nest indexing
%   ring2z     - Find HEALPix ring number corresponding to a given z coordinate
%   vec2ang    - Convert cartesian direction vector to position angle on sphere
%   vec2pix    - Convert cartesian direction vectors to MEALPix pixel numbers
%   xy2pix     - gives the pixel number ipix (NESTED) of ix, iy and face_num
%   ylm        - returns spherical harmonic basis Y_L^M on the HEALPix sphere
%   z2ring     - Find HEALPix ring numbers from direction vector z coordinate
