%Test Name: FourierLoveKernels
% Homogeneous Earth, for which analytic solutions exist. 
% Love kernels for degree 2, 20, 200 (tested against analytic solns).  
% skip benchmarking for the inner-most interface. 

% for volumetric potential
	md=model();
	
	md.materials=materials('litho');

	md.materials.numlayers = 40;
	md.love.forcing_type = 9;

	md.materials.density=zeros(md.materials.numlayers,1)+5511;
	md.materials.lame_mu=zeros(md.materials.numlayers,1)+0.75e11;
	md.materials.viscosity=zeros(md.materials.numlayers,1)+1e21;
	md.materials.lame_lambda=zeros(md.materials.numlayers,1)+5e17;
	md.materials.issolid=ones(md.materials.numlayers,1);
	md.materials.isburgers=zeros(md.materials.numlayers,1);
	md.materials.burgers_mu=md.materials.lame_mu/3;
	md.materials.burgers_viscosity=md.materials.viscosity/10;

	md.materials.radius =  linspace(10e3,6371e3,md.materials.numlayers+1)';
	md.love.g0 = 9.8134357285509388; % directly grabbed from fourierlovesolver for this particular case. 

	md.love.allow_layer_deletion=1;
	md.love.frequencies=0;
	md.love.nfreq=length(md.love.frequencies); % TODO: Why are we grabbing length of a scalar here?

	md.love.sh_nmin = 2;
	md.love.sh_nmax = 200;
	md.love.love_kernels=1; 

	md.miscellaneous.name='kernels';
	md.cluster=generic('name',oshostname(),'np',1);
	md.verbose=verbose('111111101');
	
	md=solve(md,'lv');

	% save yi's for all layers except for the inner-most one, at select degrees. 
	degrees = [2 20 200];  % we archive solutions for degrees 2, 20, 200 

	% extract love kernels {{{ 
	% degree 2. 
	y1_tidal_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,1)));
	y2_tidal_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,2)));
	y3_tidal_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,3)));
	y4_tidal_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,4)));
	y5_tidal_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,5)));
	y6_tidal_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,6)));

	% degree 20. 
	y1_tidal_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,1)));
	y2_tidal_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,2)));
	y3_tidal_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,3)));
	y4_tidal_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,4)));
	y5_tidal_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,5)));
	y6_tidal_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,6)));

	% degree 200. 
	y1_tidal_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,1)));
	y2_tidal_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,2)));
	y3_tidal_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,3)));
	y4_tidal_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,4)));
	y5_tidal_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,5)));
	y6_tidal_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,6)));
	% }}} 

% for surface load. 

	md.love.forcing_type = 11;
	md=solve(md,'lv');

	% extract love kernels {{{ 
	% degree 2. 
	y1_loading_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,1)));
	y2_loading_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,2)));
	y3_loading_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,3)));
	y4_loading_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,4)));
	y5_loading_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,5)));
	y6_loading_degree002 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(1)+1,1,2:end,6)));

	% degree 20. 
	y1_loading_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,1)));
	y2_loading_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,2)));
	y3_loading_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,3)));
	y4_loading_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,4)));
	y5_loading_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,5)));
	y6_loading_degree020 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(2)+1,1,2:end,6)));

	% degree 200. 
	y1_loading_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,1)));
	y2_loading_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,2)));
	y3_loading_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,3)));
	y4_loading_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,4)));
	y5_loading_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,5)));
	y6_loading_degree200 = squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(degrees(3)+1,1,2:end,6)));
	% }}} 

field_names = {...
	'y1_tidal_degree002','y2_tidal_degree002','y3_tidal_degree002','y4_tidal_degree002','y5_tidal_degree002','y6_tidal_degree002',...
	'y1_tidal_degree020','y2_tidal_degree020','y3_tidal_degree020','y4_tidal_degree020','y5_tidal_degree020','y6_tidal_degree020',...
	'y1_tidal_degree200','y2_tidal_degree200','y3_tidal_degree200','y4_tidal_degree200','y5_tidal_degree200','y6_tidal_degree200',...
	'y1_loading_degree002','y2_loading_degree002','y3_loading_degree002','y4_loading_degree002','y5_loading_degree002','y6_loading_degree002',...
	'y1_loading_degree020','y2_loading_degree020','y3_loading_degree020','y4_loading_degree020','y5_loading_degree020','y6_loading_degree020',...
	'y1_loading_degree200','y2_loading_degree200','y3_loading_degree200','y4_loading_degree200','y5_loading_degree200','y6_loading_degree200',...
	}; 
field_tolerances={...
    3e-7, 3e-7, 3e-7, 1e-7, 6e-8, 9e-7,...
    2e-7, 7e-8, 3e-7, 9e-8, 9e-10, 8e-10,...
    2e-8, 4e-8, 4e-7, 3e-8, 2e-10, 1e-10,...
    4e-6, 1e-6, 4e-6, 3e-6, 8e-7, 2e-6,...
    2e-6, 1e-7, 5e-6, 3e-7, 2e-7, 2e-7,...
    2e-6, 9e-10, 5e-5, 3e-8, 5e-7, 2e-9...
	}; 
field_values={...
	y1_tidal_degree002,y2_tidal_degree002,y3_tidal_degree002,y4_tidal_degree002,y5_tidal_degree002,y6_tidal_degree002,...
	y1_tidal_degree020,y2_tidal_degree020,y3_tidal_degree020,y4_tidal_degree020,y5_tidal_degree020,y6_tidal_degree020,...
	y1_tidal_degree200,y2_tidal_degree200,y3_tidal_degree200,y4_tidal_degree200,y5_tidal_degree200,y6_tidal_degree200,...
	y1_loading_degree002,y2_loading_degree002,y3_loading_degree002,y4_loading_degree002,y5_loading_degree002,y6_loading_degree002,...
	y1_loading_degree020,y2_loading_degree020,y3_loading_degree020,y4_loading_degree020,y5_loading_degree020,y6_loading_degree020,...
	y1_loading_degree200,y2_loading_degree200,y3_loading_degree200,y4_loading_degree200,y5_loading_degree200,y6_loading_degree200,...
	};

