function plot_mesh(md, options, canvas) { //{{{
	//PLOT_MESH - Function for plotting wireframe mesh.
	//
	//   Usage:
	//      plot_mesh(md, options, canvas);
	//
	//   See also: PLOTMODEL, PLOT_MANAGER

	// If we already have the overlay and are using caching, short circuit
	if ('mesh' in canvas.nodes && options.getfieldvalue('cachenodes', 'off') === 'on') {
		return;
	}
	
	/*
		Local variables
	*/
	//{{{
	//Process data and model
	var meshresults = processmesh(md, [], options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3]; 
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];
		
	//Compute coordinates and data range:
	var xlim = options.getfieldvalue('xlim', [ArrayMin(x), ArrayMax(x)]);
	var ylim = options.getfieldvalue('ylim', [ArrayMin(y), ArrayMax(y)]);
	var zlim = options.getfieldvalue('zlim', [ArrayMin(z), ArrayMax(z)]);
	
	//Handle heightscale
	var vertices, scale;
	if (md.mesh.classname() !== 'mesh3dsurface') {
		vertices = [x, y, z];
		scale = [1, 1, options.getfieldvalue('heightscale', 1)];
	}
	else {
		vertices = Node.prototype.scaleVertices(md, x, y, z, elements, options.getfieldvalue('heightscale', 1), options.getfieldvalue('maskregion',{'enabled':false}));
		scale = [1, 1, 1];
	}
	
	//Compute gl variables:
	var edgecolor = options.getfieldvalue('edgecolor', 'black');
	var node = new Node(
		'canvas', canvas,
		'options', options,
		'name', 'mesh',
		'shaderName', 'Colored',
		'alpha', options.getfieldvalue('alpha', 1.0),
		//'center', [(xlim[0] + xlim[1]) / 2, (ylim[0] + ylim[1]) / 2, md.mesh.classname() === 'mesh3dsurface' ? (zlim[0] + zlim[1]) / 2 : zlim[0]],
		'center', [(xlim[0] + xlim[1]) / 2, (ylim[0] + ylim[1]) / 2, (zlim[0] + zlim[1]) / 2],
		'drawMode', canvas.gl.LINES,
		'diffuseColor', edgecolor,
		'lineWidth', options.getfieldvalue('linewidth', 1),
		'maskEnabled', options.getfieldvalue('innermask','off') == 'on',
		'maskHeight', options.getfieldvalue('innermaskheight', 150.0) / options.getfieldvalue('heightscale', 1),
		'maskColor', options.getfieldvalue('innermaskcolor',[0.0, 0.0, 1.0, 1.0]),
		'rotation', [-90, 0, 0],
		'scale', scale
	);
	//}}}
	//{{{ node plot
	if (elements[0].length==6){ //prisms
	}
	else if (elements[0].length==4){ //tetras
	}
	else{ //2D triangular elements
		node.patch('Faces', elements, 'Vertices', vertices, 'FaceColor', 'none', 'EdgeColor', edgecolor);
	}
	//}}}
	//options=options.addfielddefault('title','Mesh');
	//options=addfielddefault('colorbar','off');
	//applyoptions(md,[],options,canvas);
} //}}}
