/*!\file IntInput2.c
 * \brief: implementation of the IntInput2 object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"
#include "./IntInput2.h"

/*IntInput2 constructors and destructor*/
IntInput2::IntInput2(){/*{{{*/
	this->size   = -1;
	this->values = NULL;
}
/*}}}*/
IntInput2::IntInput2(int size_in){/*{{{*/
	_assert_(size_in>0);
	_assert_(size_in<1e11);
	this->size   = size_in;
	this->values = xNew<int>(size_in);
}
/*}}}*/
IntInput2::~IntInput2(){/*{{{*/
	xDelete<int>(this->values);
}
/*}}}*/

/*Object virtual functions definitions:*/
Input2* IntInput2::copy() {/*{{{*/

	IntInput2* output = new IntInput2(this->size);
	xMemCpy<int>(output->values,this->values,this->size);

	return output;
}
/*}}}*/
void IntInput2::DeepEcho(void){/*{{{*/

	_printf_("IntInput2 Echo:\n");
	_printf_("   Size:          "<<size<<"\n");
	printarray(this->values,this->size);
	//_printf_(setw(15)<<"   IntInput2 "<<setw(25)<<left<<EnumToStringx(this->enum_type)<<" "<<(value?"true":"false") << "\n");
}
/*}}}*/
void IntInput2::Echo(void){/*{{{*/
	this->DeepEcho();
}
/*}}}*/
int  IntInput2::Id(void){ return -1; }/*{{{*/
/*}}}*/
void IntInput2::Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction){ /*{{{*/

	MARSHALLING_ENUM(IntInput2Enum);

	MARSHALLING(this->size);
	if(this->size > 0){
		MARSHALLING_DYNAMIC(this->values,int,this->size)
	}
	else this->values = NULL;

}
/*}}}*/
int  IntInput2::ObjectEnum(void){/*{{{*/

	return IntInput2Enum;

}
/*}}}*/

/*IntInput2 management*/
void IntInput2::GetInput(int* pvalue,int index){/*{{{*/

	_assert_(index>=0); 
	_assert_(index<this->size); 

	*pvalue = this->values[index];
}
/*}}}*/
void IntInput2::SetInput(int index,int value){/*{{{*/

	_assert_(index>=0); 
	_assert_(index<this->size); 

	this->values[index] = value;
}
/*}}}*/

/*Object functions*/
