#!/bin/bash
set -eu

#Some cleanup
rm -rf install

#Download development version, the current release never supports the latest OS X releases
git clone git://sourceware.org/git/valgrind.git install

#configure
cd install
./autogen.sh
./configure  --prefix="$ISSM_DIR/externalpackages/valgrind/install" --enable-only64bit

#Compile valgrind
if [ $# -eq 0 ]; then
	make
else
	make -j $1
fi
make install 
