#!/bin/bash
set -eu

#WARNING: make sure you have the right mpi

#Some cleanup
rm -rf install petsc-3.7.6 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://issm.ess.uci.edu/files/externalpackages/petsc-lite-3.7.6.tar.gz' 'petsc-3.7.6.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.7.6.tar.gz
mv petsc-3.7.6/* src/
rm -rf petsc-3.7.6

#configure
cd src
./config/configure.py \
 --prefix="$ISSM_DIR/externalpackages/petsc/install" \
 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
 --with-blas-lapack-dir="/sopt/MKL/2018.3/" \
 --with-mpi-dir="/sopt/OpenMPI/3.1.2/intel-2018.3-slim" \
 --known-mpi-shared-libraries=1 \
 --with-debugging=0 \
 --with-valgrind=0 \
 --with-x=0 \
 --with-ssl=0 \
 --with-batch=1  \
 --with-shared-libraries=1 \
 --download-metis=1 \
 --download-parmetis=1 \
 --download-scalapack=1 \
 --download-mumps=1 \
 --with-pic=1

#prepare script to reconfigure petsc
cat > script.queue << EOF
#!/bin/bash
#SBATCH -p ilg2.3
#SBATCH -N 1 -n 1
#SBATCH --mem-per-cpu=1gb
#SBATCH --time=10
#SBATCH --job-name=test

module load intel/2018.3
module load openmpi/3.1.2-slim

cd $(echo $ISSM_DIR)/externalpackages/petsc/src/
mpiexec -np 1 ./conftest-arch-linux2-c-opt
EOF

#print instructions
echo "== Now: cd src/ "
echo "== sbatch script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
