import numpy as np


def ibcao(nsea, nland):
    '''IBCAO - IBCAO color map

       Usage:
          map = ibcap(nsea, nland)
    '''

    Jsea = [0.18039, 0.29020, 0.57255,
            0.18039, 0.29020, 0.57255,
            0.05882, 0.44314, 0.65490,
            0.05882, 0.44314, 0.65490,
            0.02745, 0.49804, 0.73725,
            0.02745, 0.49804, 0.73725,
            0.01176, 0.54510, 0.78824,
            0.01176, 0.54510, 0.78824,
            0.00784, 0.63529, 0.83922,
            0.00784, 0.63529, 0.83922,
            0.06667, 0.71765, 0.86667,
            0.06667, 0.71765, 0.86667,
            0.17647, 0.75294, 1.00000,
            0.17647, 0.75294, 1.00000,
            0.23529, 0.76471, 0.85882,
            0.23529, 0.76471, 0.85882,
            0.24314, 0.76471, 0.83922,
            0.24314, 0.76471, 0.83922,
            0.25882, 0.76078, 0.81176,
            0.25882, 0.76078, 0.81176,
            0.27451, 0.76078, 0.76078,
            0.27451, 0.76078, 0.76078,
            0.41961, 0.78431, 0.74902,
            0.41961, 0.78431, 0.74902,
            0.60000, 0.83137, 0.74902,
            0.60000, 0.83137, 0.74902]

    Jland = [0.85098, 0.84314, 0.30588,
             0.85098, 0.84314, 0.30588,
             0.93333, 0.89020, 0.41961,
             0.93333, 0.89020, 0.41961,
             0.93725, 0.80784, 0.35686,
             0.93725, 0.80784, 0.35686,
             0.89804, 0.74510, 0.31765,
             0.89804, 0.74510, 0.31765,
             0.85098, 0.63922, 0.21961,
             0.85098, 0.63922, 0.21961,
             0.75686, 0.55294, 0.22353,
             0.75686, 0.55294, 0.22353,
             0.71765, 0.50980, 0.22353,
             0.71765, 0.50980, 0.22353,
             0.68627, 0.48235, 0.21961,
             0.68627, 0.48235, 0.21961,
             0.65490, 0.45882, 0.21569,
             0.65490, 0.45882, 0.21569,
             0.58824, 0.39608, 0.20392,
             0.58824, 0.39608, 0.20392,
             1.00000, 1.00000, 1.00000]

    # Jsea and Jland are each a series of r, g, b triples, reshape them as such

    lsea = int(len(Jsea) / 3)
    Jsea = np.array(Jsea).reshape(lsea, 3)
    a = np.linspace(1, lsea, nsea)
    b = np.arange(1, lsea + 1)
    # interpolate color on each channel r, g, b
    ysea = np.array([np.interp(a, b, Jsea[:, i]) for i in range(3)])

    lland = int(len(Jland) / 3)
    Jland = np.array(Jland).reshape(lland, 3)
    a = np.linspace(1, lland, nland)
    b = np.arange(1, lland + 1)
    # interpolate color on each channel r, g, b
    yland = np.array([np.interp(a, b, Jland[:, i]) for i in range(3)])

    # concatenate and transpose to match matplotlib's colormap format
    map = np.concatenate((ysea, yland), axis=1).T

    return map
