function [xout,yout] = CoordTransform(xin,yin,projin,projout)
%COORDTRANSFORM - use PROJ to transform coordinates
%
%   Usage:
%      [xout,yout] = CoordTransform(xin,yin,projin,projout)
%
%   xin,  yin : input coordinates
%   xout, yout: output coordinates (in new projection)
%   projin,projout: input/output projection string (PROJ)
%
%   This function will only work of PROJ has been installed in externalpackages

% Check usage
if nargin~=4
	help CoordTransform
	error('Wrong usage (see above)');
end

% Call mex module
[xout, yout] = CoordTransform_matlab(xin,yin,projin,projout);

