from checkfield import checkfield
from fielddisplay import fielddisplay
from project3d import project3d
from WriteData import WriteData


class friction(object):
    '''
    FRICTION class definition

        Usage:
            friction = friction()
    '''

    def __init__(self):  # {{{
        self.coefficient = float('NaN')
        self.p = float('NaN')
        self.q = float('NaN')
        self.coupling = 0
        self.effective_pressure = float('NaN')
        self.effective_pressure_limit = 0
        #set defaults
        self.setdefaultparameters()
        #self.requested_outputs = []
    #}}}

    def __repr__(self):  # {{{
        string = "Basal shear stress parameters: Sigma_b = coefficient^2 * Neff ^r * |u_b|^(s - 1) * u_b, \n(effective stress Neff = rho_ice * g * thickness + rho_water * g * base, r = q / p and s = 1 / p)"

        string = "%s\n%s" % (string, fielddisplay(self, "coefficient", "friction coefficient [SI]"))
        string = "%s\n%s" % (string, fielddisplay(self, "p", "p exponent"))
        string = "%s\n%s" % (string, fielddisplay(self, "q", "q exponent"))
        string = "%s\n%s" % (string, fielddisplay(self, 'coupling', 'Coupling flag 0: uniform sheet (negative pressure ok, default), 1: ice pressure only, 2: water pressure assuming uniform sheet (no negative pressure), 3: use provided effective_pressure, 4: used coupled model (not implemented yet)'))
        string = "%s\n%s" % (string, fielddisplay(self, 'effective_pressure', 'Effective Pressure for the forcing if not coupled [Pa]'))
        string = "%s\n%s" % (string, fielddisplay(self, 'effective_pressure_limit', 'Neff do not allow to fall below a certain limit: effective_pressure_limit * rho_ice * g * thickness (default 0)'))
        #string = "%s\n%s" % (string, fielddisplay(self, 'requested_outputs', 'additional outputs requested'))
        return string
    #}}}

    def extrude(self, md):  # {{{
        self.coefficient = project3d(md, 'vector', self.coefficient, 'type', 'node', 'layer', 1)
        self.p = project3d(md, 'vector', self.p, 'type', 'element')
        self.q = project3d(md, 'vector', self.q, 'type', 'element')
    #if self.coupling == 0:  #doesnt work with empty loop, so just skip it?
        if self.coupling in[3, 4]:
            self.effective_pressure = project3d(md, 'vector', self.effective_pressure, 'type', 'node', 'layer', 1)
        elif self.coupling > 4:
            raise ValueError('md.friction.coupling larger than 4, not supported yet')
        return self
    #}}}

    def setdefaultparameters(self):  # {{{
        #self.requested_outputs = ['default']
        self.effective_pressure_limit = 0
        return self
    #}}}

    def defaultoutputs(self, md):  # {{{
        list = []
        return list
    #}}}

    def checkconsistency(self, md, solution, analyses):  # {{{
        #Early return
        if 'StressbalanceAnalysis' not in analyses and 'ThermalAnalysis' not in analyses:
            return md

        md = checkfield(md, 'fieldname', 'friction.coefficient', 'timeseries', 1, 'NaN', 1, 'Inf', 1)
        md = checkfield(md, 'fieldname', 'friction.q', 'NaN', 1, 'Inf', 1, 'size', [md.mesh.numberofelements])
        md = checkfield(md, 'fieldname', 'friction.p', 'NaN', 1, 'Inf', 1, 'size', [md.mesh.numberofelements])
        md = checkfield(md, 'fieldname', 'friction.coupling', 'numel', [1], 'values', [0, 1, 2, 3, 4])
        md = checkfield(md, 'fieldname', 'friction.effective_pressure_limit', 'numel', [1], '>=', 0)
        if self.coupling == 3:
            md = checkfield(md, 'fieldname', 'friction.effective_pressure', 'NaN', 1, 'Inf', 1, 'timeseries', 1)
        elif self.coupling > 4:
            raise ValueError('md.friction.coupling larger than 4, not supported yet')
        #md = checkfield(md, 'fieldname', 'friction.requested_outputs', 'stringrow', 1)
        return md
    # }}}

    def marshall(self, prefix, md, fid):  # {{{
        WriteData(fid, prefix, 'name', 'md.friction.law', 'data', 1, 'format', 'Integer')
        WriteData(fid, prefix, 'object', self, 'fieldname', 'coefficient', 'format', 'DoubleMat', 'mattype', 1)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'p', 'format', 'DoubleMat', 'mattype', 2)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'q', 'format', 'DoubleMat', 'mattype', 2)
        WriteData(fid, prefix, 'class', 'friction', 'object', self, 'fieldname', 'coupling', 'format', 'Integer')
        WriteData(fid, prefix, 'object', self, 'class', 'friction', 'fieldname', 'effective_pressure_limit', 'format', 'Double')
        if self.coupling == 3:
            WriteData(fid, prefix, 'class', 'friction', 'object', self, 'fieldname', 'effective_pressure', 'format', 'DoubleMat', 'mattype', 1, 'timeserieslength', md.mesh.numberofvertices + 1, 'yts', md.constants.yts)
        if self.coupling == 4:
            WriteData(fid, prefix, 'class', 'friction', 'object', self, 'fieldname', 'effective_pressure', 'format', 'DoubleMat', 'mattype', 1)
        elif self.coupling > 4:
            raise ValueError('md.friction.coupling larger than 4, not supported yet')

    # #process requested outputs
    #     outputs = self.requested_outputs
    #     indices = [i for i, x in enumerate(outputs) if x == 'default']
    #     if len(indices) > 0:
    #         outputscopy = outputs[0:max(0, indices[0] - 1)] + self.defaultoutputs(md) + outputs[indices[0] + 1:]
    #         outputs = outputscopy
    #     WriteData(fid, prefix, 'data', outputs, 'name', 'md.friction.requested_outputs', 'format', 'StringArray')
    # }}}
