//FRICTION class definition
//
//   Usage:
//      friction=friction();

function friction (){
	//methods
	this.setdefaultparameters = function(){ // {{{

	} // }}}
	this.disp= function (){// {{{
		console.log(sprintf('Basal shear stress parameters: Sigma_b = coefficient^2 * Neff ^r * |u_b|^(s-1) * u_b\n(effective stress Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p)'));
		fielddisplay(this,'coefficient','friction coefficient [SI]');
		fielddisplay(this,'p','p exponent');
		fielddisplay(this,'q','q exponent');
		fielddisplay(this,'coupling','Coupling flag: 0 for default, 1 for forcing(provide md.friction.effective_pressure)  and 2 for coupled(not implemented yet)');
	} // }}}
	this.extrude = function(md) {//{{{
		this.coefficient = project3d(md, 'vector', this.coefficient, 'type', 'node', 'layer', 1);
		this.p = project3d(md, 'vector', this.p, 'type', 'element');
		this.q = project3d(md, 'vector', this.q, 'type', 'element');
		switch (this.coupling) {
			case 0:
			case 1:
				this.effective_pressure=project3d(md, 'vector', this.effective_pressure, 'type', 'node', 'layer', 1);
				break;
			case 2:
				console.error('not implemented yet');
				break;
			default:	
				console.error('not supported yet');
		}
		return this;
	}//}}}
	this.classname= function (){// {{{
		return "friction";
	} // }}}
		this.checkconsistency = function(md,solution,analyses){ //{{{

			//Early return
			if ((!ArrayAnyEqual(ArrayIsMember('StressbalanceAnalysis',analyses),1)) & (!ArrayAnyEqual(ArrayIsMember('StressbalanceAnalysis',analyses),1))){
				return; 
			}
			md = checkfield(md,'fieldname','friction.coefficient','timeseries',1,'NaN',1,'Inf',1);
			md = checkfield(md,'fieldname','friction.q','NaN',1,'Inf',1,'size',[md.mesh.numberofelements ,1]);
			md = checkfield(md,'fieldname','friction.p','NaN',1,'Inf',1,'size',[md.mesh.numberofelements ,1]);
			md = checkfield(md,'fieldname','friction.coupling','numel',[1],'values',[0, 1, 2]);
			switch (this.coupling) {
				case 0:
				case 1:
					md = checkfield(md,'fieldname','friction.effective_pressure','NaN',1,'Inf',1,'timeseries',1);
					break;
				case 2:
					console.error('not implemented yet');
					break;
				default:	
					console.error('not supported yet');
			}

		} // }}}
		this.marshall=function(md,prefix,fid) { //{{{
			var yts=md.constants.yts;

			WriteData(fid,prefix,'name','md.friction.law','data',1,'format','Integer');
			WriteData(fid,prefix,'object',this,'fieldname','coefficient','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
			//WriteData(fid,prefix,'object',this,'fieldname','coefficient','format','DoubleMat','mattype',1);
			WriteData(fid,prefix,'object',this,'fieldname','p','format','DoubleMat','mattype',2);
			WriteData(fid,prefix,'object',this,'fieldname','q','format','DoubleMat','mattype',2);
			WriteData(fid,prefix,'class','friction','object',this,'fieldname','coupling','format','Integer');
			switch (this.coupling) {
				case 0:
				case 1:
					WriteData(fid,prefix,'class','friction','object',this,'fieldname','effective_pressure','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
					break;
				case 2:
					console.error('not implemented yet');
					break;
				default:
					console.error('not supported yet');		
			}
			

		}//}}}
		this.fix=function() { //{{{
		}//}}}
	//properties 
	//{{{
	this.coefficient = NaN;
	this.p           = NaN;
	this.q           = NaN;
	this.coupling    = 0;
	this.effective_pressure = NaN;
	this.setdefaultparameters();
	//}}}
}
