/*!\file ElementInput2.c
 * \brief: implementation of the ElementInput2 object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"
#include "./ElementInput2.h"

/*ElementInput2 constructors and destructor*/
ElementInput2::ElementInput2(){/*{{{*/
	this->interpolation  = -1;
	this->M              = -1;
	this->N              = -1;
	this->isserved       = false;
	this->element_values = NULL;
	this->values         = NULL;
}
/*}}}*/
ElementInput2::~ElementInput2(){/*{{{*/
	if(this->element_values) xDelete<IssmDouble>(this->element_values);
	if(this->values)         xDelete<IssmDouble>(this->values);
}
/*}}}*/

/*Numerics*/
int ElementInput2::GetInputInterpolationType(void){/*{{{*/

	return this->interpolation;

}/*}}}*/
